/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.VisibleRegion;

public interface IProjectionDelegate
extends IInterface {
    public LatLng fromScreenLocation(b var1) throws RemoteException;

    public b toScreenLocation(LatLng var1) throws RemoteException;

    public VisibleRegion getVisibleRegion() throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IProjectionDelegate$a
    extends Binder
    implements IProjectionDelegate {
        public static IProjectionDelegate Z(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
            if (iInterface != null && iInterface instanceof IProjectionDelegate) {
                return (IProjectionDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IProjectionDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    b b2 = b.a.z(data.readStrongBinder());
                    LatLng latLng = this.fromScreenLocation(b2);
                    reply.writeNoException();
                    if (latLng != null) {
                        reply.writeInt(1);
                        latLng.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.createFromParcel(data) : null;
                    b b3 = this.toScreenLocation(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(b3 != null ? b3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    VisibleRegion visibleRegion = this.getVisibleRegion();
                    reply.writeNoException();
                    if (visibleRegion != null) {
                        reply.writeInt(1);
                        visibleRegion.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements IProjectionDelegate {
            private IBinder dG;

            a(IBinder iBinder) {
                this.dG = iBinder;
            }

            public IBinder asBinder() {
                return this.dG;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LatLng fromScreenLocation(b point) throws RemoteException {
                LatLng latLng;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    parcel.writeStrongBinder(point != null ? point.asBinder() : null);
                    this.dG.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    latLng = 0 != parcel2.readInt() ? LatLng.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return latLng;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public b toScreenLocation(LatLng location) throws RemoteException {
                b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.dG.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.z(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public VisibleRegion getVisibleRegion() throws RemoteException {
                VisibleRegion visibleRegion;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    this.dG.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    visibleRegion = 0 != parcel2.readInt() ? VisibleRegion.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return visibleRegion;
            }
        }
    }
}

