/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorPathFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.platform.base.Platform;

@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private final CompileOptions compileOptions;
    private JavaToolChain toolChain;

    public JavaCompile() {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = (CompileOptions)((Object)((ObjectFactory)this.getServices().get(ObjectFactory.class)).newInstance(CompileOptions.class, new Object[0]));
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, (TaskOutputs)this.getOutputs());
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    @Incubating
    public JavaToolChain getToolChain() {
        if (this.toolChain != null) {
            return this.toolChain;
        }
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        DefaultJavaCompileSpec spec = this.createSpec();
        Compiler<JavaCompileSpec> incrementalCompiler = this.getIncrementalCompilerFactory().makeIncremental(this.createCompiler(spec), this.getPath(), inputs, this.getSource());
        this.performCompilation(spec, incrementalCompiler);
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }

    protected void compile() {
        DefaultJavaCompileSpec spec = this.createSpec();
        spec.setSourceFiles((Iterable)this.getSource());
        this.performCompilation(spec, this.createCompiler(spec));
    }

    private CleaningJavaCompiler createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = CompilerUtil.castCompiler((Compiler)((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler((Compiler<JavaCompileSpec>)javaCompiler, this.getOutputs());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return new DefaultJavaPlatform(JavaVersion.toVersion((Object)this.getTargetCompatibility()));
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = compiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setAnnotationProcessorPath((List<File>)ImmutableList.copyOf((Iterable)this.getEffectiveAnnotationProcessorPath()));
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        return spec;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Incubating
    @Classpath
    public FileCollection getEffectiveAnnotationProcessorPath() {
        AnnotationProcessorPathFactory annotationProcessorPathFactory = (AnnotationProcessorPathFactory)this.getServices().get(AnnotationProcessorPathFactory.class);
        return annotationProcessorPathFactory.getEffectiveAnnotationProcessorClasspath(this.compileOptions, this.getClasspath());
    }
}

