/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Properties;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.GUtil;

public class DefaultFileAccessTimeJournal
implements FileAccessTimeJournal,
Stoppable {
    public static final String CACHE_KEY = "journal-1";
    public static final String FILE_ACCESS_CACHE_NAME = "file-access";
    public static final String FILE_ACCESS_PROPERTIES_FILE_NAME = "file-access.properties";
    public static final String INCEPTION_TIMESTAMP_KEY = "inceptionTimestamp";
    private final PersistentCache cache;
    private final PersistentIndexedCache<File, Long> store;
    private final long inceptionTimestamp;

    public DefaultFileAccessTimeJournal(CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory) {
        this.cache = cacheRepository.cache(CACHE_KEY).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("journal cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        this.store = this.cache.createCache(PersistentIndexedCacheParameters.of((String)FILE_ACCESS_CACHE_NAME, (Serializer)BaseSerializerFactory.FILE_SERIALIZER, (Serializer)BaseSerializerFactory.LONG_SERIALIZER).cacheDecorator(cacheDecoratorFactory.decorator(1000, true)));
        this.inceptionTimestamp = this.loadOrPersistInceptionTimestamp();
    }

    private Long loadOrPersistInceptionTimestamp() {
        return (Long)this.cache.useCache((Factory)new Factory<Long>(){

            public Long create() {
                Properties properties;
                String inceptionTimestamp;
                File propertiesFile = new File(DefaultFileAccessTimeJournal.this.cache.getBaseDir(), DefaultFileAccessTimeJournal.FILE_ACCESS_PROPERTIES_FILE_NAME);
                if (propertiesFile.exists() && (inceptionTimestamp = (properties = GUtil.loadProperties((File)propertiesFile)).getProperty(DefaultFileAccessTimeJournal.INCEPTION_TIMESTAMP_KEY)) != null) {
                    return Long.valueOf(inceptionTimestamp);
                }
                long inceptionTimestamp2 = System.currentTimeMillis();
                Properties properties2 = new Properties();
                properties2.setProperty(DefaultFileAccessTimeJournal.INCEPTION_TIMESTAMP_KEY, String.valueOf(inceptionTimestamp2));
                GUtil.saveProperties((Properties)properties2, (File)propertiesFile);
                return inceptionTimestamp2;
            }
        });
    }

    public void stop() {
        this.cache.close();
    }

    public void setLastAccessTime(File file, long millis) {
        this.store.put((Object)file, (Object)millis);
    }

    public long getLastAccessTime(File file) {
        Long value = (Long)this.store.get((Object)file);
        if (value == null) {
            return Math.max(this.inceptionTimestamp, file.lastModified());
        }
        return value;
    }

    public void deleteLastAccessTime(File file) {
        this.store.remove((Object)file);
    }
}

