/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.SpaceStation;
import megamek.common.Tank;
import megamek.common.TeleMissile;
import megamek.common.Warship;

public class MechTileset {
    private String LIGHT_STRING = "default_light";
    private String MEDIUM_STRING = "default_medium";
    private String HEAVY_STRING = "default_heavy";
    private String ASSAULT_STRING = "default_assault";
    private String QUAD_STRING = "default_quad";
    private String TRACKED_STRING = "default_tracked";
    private String TRACKED_HEAVY_STRING = "default_tracked_heavy";
    private String TRACKED_ASSAULT_STRING = "default_tracked_assault";
    private String WHEELED_STRING = "default_wheeled";
    private String WHEELED_HEAVY_STRING = "default_wheeled_heavy";
    private String HOVER_STRING = "default_hover";
    private String NAVAL_STRING = "default_naval";
    private String SUBMARINE_STRING = "default_submarine";
    private String HYDROFOIL_STRING = "default_hydrofoil";
    private String VTOL_STRING = "default_vtol";
    private String INF_STRING = "default_infantry";
    private String BA_STRING = "default_ba";
    private String PROTO_STRING = "default_proto";
    private String GUN_EMPLACEMENT_STRING = "default_gun_emplacement";
    private String WIGE_STRING = "default_wige";
    private String AERO_STRING = "default_aero";
    private String SMALL_CRAFT_AERO_STRING = "default_small_craft_aero";
    private String SMALL_CRAFT_SPHERE_STRING = "default_small_craft_sphere";
    private String DROPSHIP_AERO_STRING = "default_dropship_aero";
    private String DROPSHIP_SPHERE_STRING = "default_dropship_sphere";
    private String JUMPSHIP_STRING = "default_jumpship";
    private String WARSHIP_STRING = "default_warship";
    private String SPACE_STATION_STRING = "default_space_station";
    private String FIGHTER_SQUADRON_STRING = "default_fighter_squadron";
    private String TELE_MISSILE_STRING = "default_tele_missile";
    private MechEntry default_light;
    private MechEntry default_medium;
    private MechEntry default_heavy;
    private MechEntry default_assault;
    private MechEntry default_quad;
    private MechEntry default_tracked;
    private MechEntry default_tracked_heavy;
    private MechEntry default_tracked_assault;
    private MechEntry default_wheeled;
    private MechEntry default_wheeled_heavy;
    private MechEntry default_hover;
    private MechEntry default_naval;
    private MechEntry default_submarine;
    private MechEntry default_hydrofoil;
    private MechEntry default_vtol;
    private MechEntry default_inf;
    private MechEntry default_ba;
    private MechEntry default_proto;
    private MechEntry default_gun_emplacement;
    private MechEntry default_wige;
    private MechEntry default_aero;
    private MechEntry default_small_craft_aero;
    private MechEntry default_small_craft_sphere;
    private MechEntry default_dropship_aero;
    private MechEntry default_dropship_sphere;
    private MechEntry default_jumpship;
    private MechEntry default_warship;
    private MechEntry default_space_station;
    private MechEntry default_fighter_squadron;
    private MechEntry default_tele_missile;
    private HashMap<String, MechEntry> exact = new HashMap();
    private HashMap<String, MechEntry> chassis = new HashMap();
    private String dir;

    public MechTileset(String string) {
        this.dir = string;
    }

    public Image imageFor(Entity entity, Component component) {
        MechEntry mechEntry = this.entryFor(entity);
        if (mechEntry == null) {
            System.err.println("Entry is null make sure that their is a default entry for " + entity.getShortNameRaw() + " in both mechset.txt and wreckset.txt.  Default to " + this.LIGHT_STRING);
            System.err.flush();
            mechEntry = this.default_light;
        }
        if (mechEntry.getImage() == null) {
            mechEntry.loadImage(component);
        }
        return mechEntry.getImage();
    }

    private MechEntry entryFor(Entity entity) {
        if (this.exact.containsKey(entity.getShortNameRaw().toUpperCase())) {
            return this.exact.get(entity.getShortNameRaw().toUpperCase());
        }
        if (this.chassis.containsKey(entity.getChassis().toUpperCase())) {
            return this.chassis.get(entity.getChassis().toUpperCase());
        }
        return this.genericFor(entity);
    }

    public MechEntry genericFor(Entity entity) {
        if (entity instanceof BattleArmor) {
            return this.default_ba;
        }
        if (entity instanceof Infantry) {
            return this.default_inf;
        }
        if (entity instanceof Protomech) {
            return this.default_proto;
        }
        if (entity instanceof Mech) {
            if (entity.getMovementMode() == 2) {
                return this.default_quad;
            }
            if (entity.getWeightClass() == 0) {
                return this.default_light;
            }
            if (entity.getWeightClass() == 1) {
                return this.default_medium;
            }
            if (entity.getWeightClass() == 2) {
                return this.default_heavy;
            }
            if (entity.getWeightClass() == 3) {
                return this.default_assault;
            }
        }
        if (entity.getMovementMode() == 7) {
            return this.default_naval;
        }
        if (entity.getMovementMode() == 9) {
            return this.default_submarine;
        }
        if (entity.getMovementMode() == 8) {
            return this.default_hydrofoil;
        }
        if (entity instanceof Tank) {
            if (entity.getMovementMode() == 3) {
                if (entity.getWeightClass() == 2) {
                    return this.default_tracked_heavy;
                }
                if (entity.getWeightClass() == 3) {
                    return this.default_tracked_assault;
                }
                return this.default_tracked;
            }
            if (entity.getMovementMode() == 4) {
                if (entity.getWeightClass() == 2) {
                    return this.default_wheeled_heavy;
                }
                return this.default_wheeled;
            }
            if (entity.getMovementMode() == 5) {
                return this.default_hover;
            }
            if (entity.getMovementMode() == 6) {
                return this.default_vtol;
            }
            if (entity.getMovementMode() == 15) {
                return this.default_wige;
            }
        }
        if (entity instanceof GunEmplacement) {
            return this.default_gun_emplacement;
        }
        if (entity instanceof Aero) {
            if (entity instanceof SpaceStation) {
                return this.default_space_station;
            }
            if (entity instanceof Warship) {
                return this.default_warship;
            }
            if (entity instanceof Jumpship) {
                return this.default_jumpship;
            }
            if (entity instanceof Dropship) {
                Dropship dropship = (Dropship)entity;
                if (dropship.isSpheroid()) {
                    return this.default_dropship_sphere;
                }
                return this.default_dropship_aero;
            }
            if (entity instanceof FighterSquadron) {
                return this.default_fighter_squadron;
            }
            if (entity instanceof SmallCraft) {
                SmallCraft smallCraft = (SmallCraft)entity;
                if (smallCraft.isSpheroid()) {
                    return this.default_small_craft_sphere;
                }
                return this.default_small_craft_aero;
            }
            if (entity instanceof TeleMissile) {
                return this.default_tele_missile;
            }
            return this.default_aero;
        }
        throw new IndexOutOfBoundsException("can't find an image for that mech");
    }

    public void loadFromFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.dir + string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.wordChars(95, 95);
        while (streamTokenizer.nextToken() != -1) {
            String string2 = null;
            String string3 = null;
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("include")) {
                streamTokenizer.nextToken();
                string2 = streamTokenizer.sval;
                System.out.print("Loading more unit images from ");
                System.out.print(string2);
                System.out.println("...");
                try {
                    this.loadFromFile(string2);
                    System.out.print("... finished ");
                    System.out.print(string2);
                    System.out.println(".");
                }
                catch (IOException iOException) {
                    System.out.print("... failed: ");
                    System.out.print(iOException.getMessage());
                    System.out.println(".");
                }
                continue;
            }
            if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("chassis")) {
                streamTokenizer.nextToken();
                string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                string3 = streamTokenizer.sval;
                this.chassis.put(string2.toUpperCase(), new MechEntry(string2, string3));
                continue;
            }
            if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("exact")) continue;
            streamTokenizer.nextToken();
            string2 = streamTokenizer.sval;
            streamTokenizer.nextToken();
            string3 = streamTokenizer.sval;
            this.exact.put(string2.toUpperCase(), new MechEntry(string2, string3));
        }
        ((Reader)bufferedReader).close();
        this.default_light = this.exact.get(this.LIGHT_STRING.toUpperCase());
        this.default_medium = this.exact.get(this.MEDIUM_STRING.toUpperCase());
        this.default_heavy = this.exact.get(this.HEAVY_STRING.toUpperCase());
        this.default_assault = this.exact.get(this.ASSAULT_STRING.toUpperCase());
        this.default_quad = this.exact.get(this.QUAD_STRING.toUpperCase());
        this.default_tracked = this.exact.get(this.TRACKED_STRING.toUpperCase());
        this.default_tracked_heavy = this.exact.get(this.TRACKED_HEAVY_STRING.toUpperCase());
        this.default_tracked_assault = this.exact.get(this.TRACKED_ASSAULT_STRING.toUpperCase());
        this.default_wheeled = this.exact.get(this.WHEELED_STRING.toUpperCase());
        this.default_wheeled_heavy = this.exact.get(this.WHEELED_HEAVY_STRING.toUpperCase());
        this.default_hover = this.exact.get(this.HOVER_STRING.toUpperCase());
        this.default_naval = this.exact.get(this.NAVAL_STRING.toUpperCase());
        this.default_submarine = this.exact.get(this.SUBMARINE_STRING.toUpperCase());
        this.default_hydrofoil = this.exact.get(this.HYDROFOIL_STRING.toUpperCase());
        this.default_vtol = this.exact.get(this.VTOL_STRING.toUpperCase());
        this.default_inf = this.exact.get(this.INF_STRING.toUpperCase());
        this.default_ba = this.exact.get(this.BA_STRING.toUpperCase());
        this.default_proto = this.exact.get(this.PROTO_STRING.toUpperCase());
        this.default_gun_emplacement = this.exact.get(this.GUN_EMPLACEMENT_STRING.toUpperCase());
        this.default_wige = this.exact.get(this.WIGE_STRING.toUpperCase());
        this.default_aero = this.exact.get(this.AERO_STRING.toUpperCase());
        this.default_small_craft_aero = this.exact.get(this.SMALL_CRAFT_AERO_STRING.toUpperCase());
        this.default_dropship_aero = this.exact.get(this.DROPSHIP_AERO_STRING.toUpperCase());
        this.default_small_craft_sphere = this.exact.get(this.SMALL_CRAFT_SPHERE_STRING.toUpperCase());
        this.default_dropship_sphere = this.exact.get(this.DROPSHIP_SPHERE_STRING.toUpperCase());
        this.default_jumpship = this.exact.get(this.JUMPSHIP_STRING.toUpperCase());
        this.default_warship = this.exact.get(this.WARSHIP_STRING.toUpperCase());
        this.default_space_station = this.exact.get(this.SPACE_STATION_STRING.toUpperCase());
        this.default_fighter_squadron = this.exact.get(this.FIGHTER_SQUADRON_STRING.toUpperCase());
        this.default_tele_missile = this.exact.get(this.TELE_MISSILE_STRING.toUpperCase());
    }

    private class MechEntry {
        private String name;
        private String imageFile;
        private Image image;

        public MechEntry(String string, String string2) {
            this.name = string;
            this.imageFile = string2;
            this.image = null;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return this.image;
        }

        public void loadImage(Component component) {
            this.image = component.getToolkit().getImage(MechTileset.this.dir + this.imageFile);
        }
    }
}

