/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LosEffects;
import megamek.common.SupportTank;

public class LargeSupportTank
extends SupportTank
implements Serializable {
    private static final long serialVersionUID = -3177191060629774478L;
    public static final int LOC_BODY = 0;
    public static final int LOC_FRONT = 1;
    public static final int LOC_FRONTRIGHT = 2;
    public static final int LOC_FRONTLEFT = 3;
    public static final int LOC_REARRIGHT = 4;
    public static final int LOC_REARLEFT = 5;
    public static final int LOC_REAR = 6;
    public static final int LOC_TURRET = 7;
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "FRRS", "FRLS", "RRRS", "RRLS", "RR", "TU"};
    public static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Front Right", "Front Left", "Rear Right", "Rear Left", "Rear", "Turret"};

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        if (n2 == 0 && this.isHullDown() && !this.m_bHasNoTurret) {
            n6 = 7;
        }
        if (n2 == 4) {
            n6 = 3;
            bl = true;
            n7 = 2;
        } else if (n2 == 5) {
            n6 = 2;
            bl = true;
            n7 = 2;
        } else if (n2 == 7) {
            n6 = 4;
            bl2 = true;
            n7 = 1;
        } else if (n2 == 6) {
            n6 = 5;
            bl2 = true;
            n7 = 1;
        } else if (n2 == 1) {
            n6 = 6;
            n7 = 1;
            bl3 = true;
        }
        if (this.game.getOptions().booleanOption("tacops_vehicle_effective")) {
            n7 = 0;
        }
        HitData hitData = new HitData(n6);
        boolean bl4 = false;
        if (n3 != -1 && n4 != 0 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            hitData = new HitData(n3, n2 == 1, true);
            bl4 = true;
        }
        if (!bl4) {
            switch (Compute.d6(2)) {
                case 2: {
                    hitData.setEffect(1);
                    break;
                }
                case 3: {
                    if (bl) {
                        hitData = new HitData(1, false, 2);
                    } else if (bl3) {
                        hitData = new HitData(5, false, 2);
                    } else if (bl2) {
                        hitData.setEffect(2);
                    } else {
                        hitData = new HitData(2, false, 2);
                    }
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 4: {
                    hitData.setEffect(2);
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 5: {
                    if (!bl3 && (bl || bl2)) break;
                    hitData.setEffect(2);
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    if (!bl && !bl2 || this.game.getOptions().booleanOption("tacops_vehicle_effective")) break;
                    hitData.setEffect(1);
                    break;
                }
                case 9: {
                    if (this.game.getOptions().booleanOption("tacops_vehicle_effective")) break;
                    hitData.setEffect(2);
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 10: {
                    if (this.m_bHasNoTurret) break;
                    hitData = new HitData(7);
                    break;
                }
                case 11: {
                    if (this.m_bHasNoTurret) break;
                    hitData = new HitData(7);
                    break;
                }
                case 12: {
                    if (this.m_bHasNoTurret) {
                        hitData.setEffect(1);
                        break;
                    }
                    hitData = new HitData(7, false, 1);
                }
            }
        }
        if (n == 3) {
            hitData.setEffect(hitData.getEffect() | 1);
        }
        return hitData;
    }

    public int sideTable(Coords coords, boolean bl, int n) {
        Coords coords2 = this.position;
        if (bl) {
            coords2 = this.getPriorPosition();
        }
        if (coords.equals(coords2)) {
            return 0;
        }
        int n2 = (coords2.degree(coords) + (6 - n) * 60) % 360;
        int n3 = 2;
        if (n2 % 30 == 0) {
            IHex iHex = this.game.getBoard().getHex(coords);
            IHex iHex2 = this.game.getBoard().getHex(this.getPosition());
            if (iHex != null && iHex2 != null) {
                LosEffects.AttackInfo attackInfo = LosEffects.buildAttackInfo(coords, this.getPosition(), 1, this.getElevation(), iHex.floor(), iHex2.floor());
                ArrayList<Coords> arrayList = Coords.intervening(attackInfo.attackPos, attackInfo.targetPos, true);
                n3 = LosEffects.dividedLeftBetter(arrayList, this.game, attackInfo, Compute.isInBuilding(this.game, this), new LosEffects());
            }
        }
        if (n2 == 330 && n3 == 0) {
            return 4;
        }
        if (n2 == 270 && n3 == 0) {
            return 6;
        }
        if (n2 == 210 && n3 == 0) {
            return 1;
        }
        if (n2 == 150 && n3 == 0) {
            return 7;
        }
        if (n2 == 90 && n3 == 1) {
            return 7;
        }
        if (n2 == 30 && n3 == 1) {
            return 5;
        }
        if (n2 > 30 && n2 <= 90) {
            return 5;
        }
        if (n2 > 90 && n2 < 150) {
            return 7;
        }
        if (n2 >= 150 && n2 < 210) {
            return 1;
        }
        if (n2 >= 210 && n2 < 270) {
            return 6;
        }
        if (n2 >= 270 && n2 < 330) {
            return 4;
        }
        return 0;
    }

    public int locations() {
        return this.m_bHasNoTurret ? 7 : 8;
    }
}

