/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.BipedMech;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.WeaponType;
import megamek.common.weapons.ISERPPC;
import megamek.common.weapons.ISHeavyPPC;
import megamek.common.weapons.ISLightPPC;
import megamek.common.weapons.ISPPC;
import megamek.common.weapons.ISSnubNosePPC;

public class MiscType
extends EquipmentType {
    public static final long F_HEAT_SINK = 1L;
    public static final long F_DOUBLE_HEAT_SINK = 2L;
    public static final long F_JUMP_JET = 4L;
    public static final long F_CASE = 8L;
    public static final long F_MASC = 16L;
    public static final long F_TSM = 32L;
    public static final long F_LASER_HEAT_SINK = 64L;
    public static final long F_C3S = 128L;
    public static final long F_C3I = 256L;
    public static final long F_ARTEMIS = 512L;
    public static final long F_TARGCOMP = 1024L;
    public static final long F_ANGEL_ECM = 2048L;
    public static final long F_BOARDING_CLAW = 4096L;
    public static final long F_VACUUM_PROTECTION = 8192L;
    public static final long F_ASSAULT_CLAW = 16384L;
    public static final long F_FIRE_RESISTANT = 32768L;
    public static final long F_STEALTH = 65536L;
    public static final long F_MINE = 131072L;
    public static final long F_TOOLS = 262144L;
    public static final long F_MAGNETIC_CLAMP = 524288L;
    public static final long F_PARAFOIL = 0x100000L;
    public static final long F_FERRO_FIBROUS = 0x200000L;
    public static final long F_ENDO_STEEL = 0x400000L;
    public static final long F_AP_POD = 0x800000L;
    public static final long F_SEARCHLIGHT = 0x1000000L;
    public static final long F_CLUB = 0x2000000L;
    public static final long F_HAND_WEAPON = 0x4000000L;
    public static final long F_COWL = 0x8000000L;
    public static final long F_JUMP_BOOSTER = 0x10000000L;
    public static final long F_HARJEL = 0x20000000L;
    public static final long F_UMU = 0x40000000L;
    public static final long F_COOLANT_SYSTEM = 0x80000000L;
    public static final long F_SPIKES = 0x100000000L;
    public static final long F_COMMUNICATIONS = 0x200000000L;
    public static final long F_PPC_CAPACITOR = 0x400000000L;
    public static final long F_REFLECTIVE = 0x800000000L;
    public static final long F_REACTIVE = 0x1000000000L;
    public static final long F_CASEII = 0x2000000000L;
    public static final long F_LIFTHOIST = 0x4000000000L;
    public static final long F_ENVIRONMENTAL_SEALING = 0x8000000000L;
    public static final long F_ARMORED_CHASSIS = 0x10000000000L;
    public static final long F_TRACTOR_MODIFICATION = 0x20000000000L;
    public static final long F_ACTUATOR_ENHANCEMENT_SYSTEM = 0x40000000000L;
    public static final long F_ECM = 0x80000000000L;
    public static final long F_BAP = 0x100000000000L;
    public static final long F_MODULAR_ARMOR = 0x200000000000L;
    public static final long F_TALON = 0x400000000000L;
    public static final long F_VISUAL_CAMO = 0x800000000000L;
    public static final long F_APOLLO = 0x1000000000000L;
    public static final long F_INDUSTRIAL_TSM = 0x2000000000000L;
    public static final long F_NULLSIG = 0x4000000000000L;
    public static final long F_VOIDSIG = 0x8000000000000L;
    public static final long F_CHAMELEON_SHIELD = 0x10000000000000L;
    public static final long F_VIBROCLAW = 0x20000000000000L;
    public static final long F_SINGLE_HEX_ECM = 0x40000000000000L;
    public static final long F_EJECTION_SEAT = 0x80000000000000L;
    public static final long F_SALVAGE_ARM = 0x100000000000000L;
    public static final long F_TRACKS = 0x200000000000000L;
    public static final long F_MASS = 0x400000000000000L;
    public static final long F_BA_EQUIPMENT = 0x800000000000000L;
    public static final long F_MECH_EQUIPMENT = 0x1000000000000000L;
    public static final long F_TANK_EQUIPMENT = 0x2000000000000000L;
    public static final long S_CLUB = 1L;
    public static final long S_TREE_CLUB = 2L;
    public static final long S_HATCHET = 4L;
    public static final long S_SWORD = 8L;
    public static final long S_MACE_THB = 16L;
    public static final long S_CLAW_THB = 32L;
    public static final long S_MACE = 64L;
    public static final long S_DUAL_SAW = 128L;
    public static final long S_FLAIL = 256L;
    public static final long S_PILE_DRIVER = 512L;
    public static final long S_SHIELD_SMALL = 1024L;
    public static final long S_SHIELD_MEDIUM = 2048L;
    public static final long S_SHIELD_LARGE = 4096L;
    public static final long S_LANCE = 8192L;
    public static final long S_VIBRO_SMALL = 16384L;
    public static final long S_VIBRO_MEDIUM = 32768L;
    public static final long S_VIBRO_LARGE = 65536L;
    public static final long S_WRECKING_BALL = 131072L;
    public static final long S_BACKHOE = 262144L;
    public static final long S_COMBINE = 524288L;
    public static final long S_CHAINSAW = 0x100000L;
    public static final long S_ROCK_CUTTER = 0x200000L;
    public static final long S_BUZZSAW = 0x400000L;
    public static final long S_RETRACTABLE_BLADE = 0x800000L;
    public static final long S_CHAIN_WHIP = 0x1000000L;
    public static final long S_SPOT_WELDER = 0x2000000L;
    public static final String S_ACTIVE_SHIELD = "Active";
    public static final String S_PASSIVE_SHIELD = "Passive";
    public static final String S_NO_SHIELD = "None";
    public static final long S_CLAW = 1L;
    public static final long S_MINING_DRILL = 2L;
    public static final long S_VIBROSHOVEL = 1L;
    public static final long S_DEMOLITION_CHARGE = 2L;
    public static final long S_BRIDGE_KIT = 4L;
    public static final long S_MINESWEEPER = 8L;
    public static final long S_HEAVY_ARMOR = 16L;
    public static final long S_SUPERCHARGER = 1L;
    public static final long S_STANDARD = 1L;
    public static final long S_IMPROVED = 2L;
    public static final int T_TARGSYS_UNKNOWN = -1;
    public static final int T_TARGSYS_STANDARD = 0;
    public static final int T_TARGSYS_TARGCOMP = 1;
    public static final int T_TARGSYS_LONGRANGE = 2;
    public static final int T_TARGSYS_SHORTRANGE = 3;
    public static final int T_TARGSYS_VARIABLE_RANGE = 4;
    public static final int T_TARGSYS_ANTI_AIR = 5;
    public static final int T_TARGSYS_MULTI_TRAC = 6;
    public static final int T_TARGSYS_MULTI_TRAC_II = 7;
    public static final int T_TARGSYS_HEAT_SEEKING_THB = 8;
    public static final String[] targSysNames = new String[]{"Standard Targeting System", "Targeting Computer", "Long-Range Targeting System", "Short-Range Targeting System", "Variable-Range Taretting System", "Anti-Air Targeting System", "Multi-Trac Targeting System", "Multi-Trac II Targeting System"};
    protected int baseDamageAbsorptionRate = 0;
    protected int baseDamageCapacity = 0;
    protected int damageTaken = 0;

    public boolean isShield() {
        return this.hasFlag(0x2000000L) && (this.hasSubType(4096L) || this.hasSubType(2048L) || this.hasSubType(1024L));
    }

    public boolean isVibroblade() {
        return this.hasFlag(0x2000000L) && (this.hasSubType(65536L) || this.hasSubType(32768L) || this.hasSubType(16384L));
    }

    public float getTonnage(Entity entity) {
        if (this.tonnage != Float.MIN_VALUE) {
            return this.tonnage;
        }
        if (this.hasFlag(4L)) {
            if (this.hasSubType(2L)) {
                if ((double)entity.getWeight() <= 55.0) {
                    return 1.0f;
                }
                if ((double)entity.getWeight() <= 85.0) {
                    return 2.0f;
                }
                return 4.0f;
            }
            if ((double)entity.getWeight() <= 55.0) {
                return 0.5f;
            }
            if ((double)entity.getWeight() <= 85.0) {
                return 1.0f;
            }
            return 2.0f;
        }
        if (this.hasFlag(0x40000000L)) {
            if ((double)entity.getWeight() <= 55.0) {
                return 0.5f;
            }
            if ((double)entity.getWeight() <= 85.0) {
                return 1.0f;
            }
            return 2.0f;
        }
        if (this.hasFlag(0x2000000L) && (this.hasSubType(4L) || this.hasSubType(16L))) {
            return (float)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(8192L)) {
            return (float)Math.ceil((double)entity.getWeight() / 20.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(8L)) {
            return (float)(Math.ceil((double)entity.getWeight() / 20.0 * 2.0) / 2.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(64L)) {
            return (float)Math.ceil((double)entity.getWeight() / 10.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(0x800000L)) {
            return 0.5f + (float)Math.ceil((double)entity.getWeight() / 10.0) / 2.0f;
        }
        if (this.hasFlag(16L)) {
            if (this.hasSubType(1L)) {
                Engine engine = entity.getEngine();
                if (engine == null) {
                    return 0.0f;
                }
                return (float)(Math.ceil((double)engine.getWeightEngine() / 10.0 * 2.0) / 2.0);
            }
            if (entity.isClan()) {
                return Math.round(entity.getWeight() / 25.0f);
            }
            return Math.round(entity.getWeight() / 20.0f);
        }
        if (this.hasFlag(1024L)) {
            double d = 0.0;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1L)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.isClan()) {
                return (float)Math.ceil(d / 5.0);
            }
            return (float)Math.ceil(d / 4.0);
        }
        if (EquipmentType.getArmorTypeName(1).equals(this.internalName)) {
            double d = 0.0;
            d = entity.isClanArmor() ? (double)entity.getTotalOArmor() / 19.2 : (double)entity.getTotalOArmor() / 17.92;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getArmorTypeName(5).equals(this.internalName)) {
            double d = (double)entity.getTotalOArmor() / 16.96;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getArmorTypeName(6).equals(this.internalName)) {
            double d = (double)entity.getTotalOArmor() / 19.84;
            d = Math.ceil(d * 2.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(1).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(2).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(3).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) * 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(4).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) / 2.0;
            return (float)d;
        }
        if (EquipmentType.getStructureTypeName(5).equals(this.internalName)) {
            double d = 0.0;
            d = Math.ceil((double)entity.getWeight() / 10.0) * 2.0;
            return (float)d;
        }
        if (this.hasFlag(8192L)) {
            return (float)Math.ceil((double)entity.getWeight() / 10.0);
        }
        if (this.hasFlag(0x8000000000L)) {
            return entity.getWeight() / 10.0f;
        }
        if (this.hasFlag(0x10000000L)) {
            return (float)(Math.ceil((double)(entity.getWeight() * (float)entity.getOriginalJumpMP()) / 10.0) / 2.0);
        }
        if (this.hasFlag(0x4000000L) && this.hasSubType(1L) || this.hasFlag(0x400000000000L)) {
            return (int)Math.ceil(entity.getWeight() / 15.0f);
        }
        if (this.hasFlag(0x40000000000L)) {
            float f = 0.0f;
            f = entity instanceof BipedMech ? entity.getWeight() / 35.0f : entity.getWeight() / 50.0f;
            if (f == (float)Math.round(f)) {
                return f;
            }
            if (Math.floor(f) < (double)Math.round(f)) {
                return Math.round(f);
            }
            return (float)(Math.floor(f) + 0.5);
        }
        if (this.hasFlag(0x200000000000000L)) {
            return entity.getWeight() / 10.0f;
        }
        return 1.0f;
    }

    public double getCost(Entity entity, boolean bl) {
        if (bl) {
            double d = this.cost;
            return d += (double)(150000 * this.getCriticals(entity));
        }
        return super.getCost(entity, bl);
    }

    public int getCriticals(Entity entity) {
        if (this.criticals != Integer.MIN_VALUE) {
            return this.criticals;
        }
        if (this.hasFlag(0x2000000L) && (this.hasSubType(4L) || this.hasSubType(8L) || this.hasSubType(16L) || this.hasSubType(0x1000000L))) {
            return (int)Math.ceil((double)entity.getWeight() / 15.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(8192L)) {
            return (int)Math.ceil((double)entity.getWeight() / 20.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(64L)) {
            return (int)Math.ceil((double)entity.getWeight() / 10.0);
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(0x800000L)) {
            return 1 + (int)Math.ceil((double)entity.getWeight() / 20.0);
        }
        if (this.hasFlag(16L)) {
            if (entity.isClan()) {
                return (int)Math.round((double)entity.getWeight() / 25.0);
            }
            return (int)Math.round((double)entity.getWeight() / 20.0);
        }
        if (this.hasFlag(1024L)) {
            double d = 0.0;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1L)) continue;
                d += (double)weaponType.getTonnage(entity);
            }
            if (entity.isClan()) {
                return (int)Math.ceil(d / 5.0);
            }
            return (int)Math.ceil(d / 4.0);
        }
        if (EquipmentType.getArmorTypeName(1).equals(this.internalName) || EquipmentType.getArmorTypeName(2).equals(this.internalName)) {
            if (entity.isClanArmor()) {
                return 7;
            }
            return 14;
        }
        if (EquipmentType.getArmorTypeName(3).equals(this.internalName)) {
            if (entity.isClanArmor()) {
                return 5;
            }
            return 10;
        }
        if (EquipmentType.getStructureTypeName(1).equals(this.internalName)) {
            if (entity.isClan()) {
                return 7;
            }
            return 14;
        }
        if (this.hasFlag(0x10000000L)) {
            return entity instanceof QuadMech ? 8 : 4;
        }
        if (this.hasFlag(0x4000000L) && this.hasSubType(1L)) {
            return (int)Math.ceil(entity.getWeight() / 15.0f);
        }
        if (this.hasFlag(0x40000000000L)) {
            return entity.getWeightClass() + 1;
        }
        if (this.hasFlag(0x200000000000000L)) {
            if (entity instanceof QuadMech) {
                return 4;
            }
            if (entity instanceof BipedMech) {
                return 2;
            }
        } else if (this.hasFlag(0x400000000000L)) {
            if (entity instanceof QuadMech) {
                return 8;
            }
            if (entity instanceof BipedMech) {
                return 4;
            }
        }
        return 1;
    }

    public double getBV(Entity entity, Mounted mounted) {
        if (this.hasFlag(0x400000000L) && mounted != null && mounted.getLinked() != null) {
            if (mounted.getLinked().getType() instanceof ISLightPPC) {
                return 44.0;
            }
            if (mounted.getLinked().getType() instanceof ISPPC) {
                return 88.0;
            }
            if (mounted.getLinked().getType() instanceof ISHeavyPPC) {
                return 53.0;
            }
            if (mounted.getLinked().getType() instanceof ISSnubNosePPC) {
                return 90.0;
            }
            if (mounted.getLinked().getType() instanceof ISERPPC) {
                return 114.0;
            }
        }
        return this.getBV(entity);
    }

    public double getBV(Entity entity) {
        double d = 0.0;
        if (this.bv != -2.147483648E9) {
            d = this.bv;
            return d;
        }
        if (this.hasFlag(0x2000000L) && this.hasSubType(4L)) {
            d = Math.ceil((double)entity.getWeight() / 5.0) * 1.5;
        } else if (this.hasFlag(0x2000000L) && this.hasSubType(16L)) {
            d = Math.ceil((double)entity.getWeight() / 5.0) * 1.5;
        } else if (this.hasFlag(0x2000000L) && this.hasSubType(8192L)) {
            d = Math.ceil((double)entity.getWeight() / 5.0) * 1.0;
        } else if (this.hasFlag(0x2000000L) && this.hasSubType(64L)) {
            d = Math.ceil((double)entity.getWeight() / 4.0);
        } else if (this.hasFlag(0x2000000L) && (this.hasSubType(8L) || this.hasSubType(0x1000000L))) {
            d = (Math.ceil((double)entity.getWeight() / 10.0) + 1.0) * 1.725;
        } else if (this.hasFlag(0x2000000L) && this.hasSubType(0x800000L)) {
            d = Math.ceil((double)entity.getWeight() / 10.0) * 1.725;
        } else if (this.hasFlag(1024L)) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1L)) continue;
                if (mounted.isRearMounted()) {
                    d3 += weaponType.getBV(entity);
                    continue;
                }
                d2 += weaponType.getBV(entity);
            }
            if (d2 > d3) {
                d = d2 * 0.2 + d3 * 0.1;
            }
            d = d3 * 0.2 + d2 * 0.1;
        } else if (this.hasFlag(0x4000000L) && this.hasSubType(1L)) {
            d = Math.ceil((double)entity.getWeight() / 7.0) * 1.275;
        } else if (this.hasFlag(0x400000000000L)) {
            d = (double)(entity.getWeight() / 5.0f) * 0.5;
        }
        return d;
    }

    public static void initializeTypes() {
        EquipmentType.addType(MiscType.createHeatSink());
        EquipmentType.addType(MiscType.createJumpJet());
        EquipmentType.addType(MiscType.createTreeClub());
        EquipmentType.addType(MiscType.createGirderClub());
        EquipmentType.addType(MiscType.createLimbClub());
        EquipmentType.addType(MiscType.createHatchet());
        EquipmentType.addType(MiscType.createVacuumProtection());
        EquipmentType.addType(MiscType.createStandard());
        EquipmentType.addType(MiscType.createISDoubleHeatSink());
        EquipmentType.addType(MiscType.createCLDoubleHeatSink());
        EquipmentType.addType(MiscType.createISCASE());
        EquipmentType.addType(MiscType.createCLCASE());
        EquipmentType.addType(MiscType.createISMASC());
        EquipmentType.addType(MiscType.createCLMASC());
        EquipmentType.addType(MiscType.createTSM());
        EquipmentType.addType(MiscType.createC3S());
        EquipmentType.addType(MiscType.createC3I());
        EquipmentType.addType(MiscType.createISArtemis());
        EquipmentType.addType(MiscType.createCLArtemis());
        EquipmentType.addType(MiscType.createGECM());
        EquipmentType.addType(MiscType.createCLECM());
        EquipmentType.addType(MiscType.createISTargComp());
        EquipmentType.addType(MiscType.createCLTargComp());
        EquipmentType.addType(MiscType.createMekStealth());
        EquipmentType.addType(MiscType.createFerroFibrous());
        EquipmentType.addType(MiscType.createEndoSteel());
        EquipmentType.addType(MiscType.createBeagleActiveProbe());
        EquipmentType.addType(MiscType.createBloodhoundActiveProbe());
        EquipmentType.addType(MiscType.createTHBBloodhoundActiveProbe());
        EquipmentType.addType(MiscType.createCLActiveProbe());
        EquipmentType.addType(MiscType.createCLLightActiveProbe());
        EquipmentType.addType(MiscType.createISAPPod());
        EquipmentType.addType(MiscType.createCLAPPod());
        EquipmentType.addType(MiscType.createSword());
        EquipmentType.addType(MiscType.createISPPCCapacitor());
        EquipmentType.addType(MiscType.createRetractableBlade());
        EquipmentType.addType(MiscType.createChainWhip());
        EquipmentType.addType(MiscType.createISApolloFCS());
        EquipmentType.addType(MiscType.createEjectionSeat());
        EquipmentType.addType(MiscType.createIndustrialTSM());
        EquipmentType.addType(MiscType.createSalvageArm());
        EquipmentType.addType(MiscType.createSpotWelder());
        EquipmentType.addType(MiscType.createLiftHoist());
        EquipmentType.addType(MiscType.createTracks());
        EquipmentType.addType(MiscType.createISMASS());
        EquipmentType.addType(MiscType.createCLMASS());
        EquipmentType.addType(MiscType.createImprovedJumpJet());
        EquipmentType.addType(MiscType.createCLImprovedJumpJet());
        EquipmentType.addType(MiscType.createJumpBooster());
        EquipmentType.addType(MiscType.createFerroFibrousPrototype());
        EquipmentType.addType(MiscType.createLightFerroFibrous());
        EquipmentType.addType(MiscType.createHeavyFerroFibrous());
        EquipmentType.addType(MiscType.createHardenedArmor());
        EquipmentType.addType(MiscType.createIndustrialArmor());
        EquipmentType.addType(MiscType.createHeavyIndustrialArmor());
        EquipmentType.addType(MiscType.createCommercialArmor());
        EquipmentType.addType(MiscType.createEndoSteelPrototype());
        EquipmentType.addType(MiscType.createReinforcedStructure());
        EquipmentType.addType(MiscType.createCompositeStructure());
        EquipmentType.addType(MiscType.createIndustrialStructure());
        EquipmentType.addType(MiscType.createIS1CompactHeatSink());
        EquipmentType.addType(MiscType.createIS2CompactHeatSinks());
        EquipmentType.addType(MiscType.createCLLaserHeatSink());
        EquipmentType.addType(MiscType.createISAngelECM());
        EquipmentType.addType(MiscType.createISTHBAngelECM());
        EquipmentType.addType(MiscType.createCLAngelECM());
        EquipmentType.addType(MiscType.createWatchdogECM());
        EquipmentType.addType(MiscType.createTHBMace());
        EquipmentType.addType(MiscType.createMace());
        EquipmentType.addType(MiscType.createDualSaw());
        EquipmentType.addType(MiscType.createChainsaw());
        EquipmentType.addType(MiscType.createRockCutter());
        EquipmentType.addType(MiscType.createBackhoe());
        EquipmentType.addType(MiscType.createPileDriver());
        EquipmentType.addType(MiscType.createArmoredCowl());
        EquipmentType.addType(MiscType.createNullSignatureSystem());
        EquipmentType.addType(MiscType.createVoidSignatureSystem());
        EquipmentType.addType(MiscType.createChameleonLightPolarizationField());
        EquipmentType.addType(MiscType.createLightMinesweeper());
        EquipmentType.addType(MiscType.createBridgeKit());
        EquipmentType.addType(MiscType.createVibroShovel());
        EquipmentType.addType(MiscType.createDemolitionCharge());
        EquipmentType.addType(MiscType.createISSuperCharger());
        EquipmentType.addType(MiscType.createCLSuperCharger());
        EquipmentType.addType(MiscType.createISMediumShield());
        EquipmentType.addType(MiscType.createISSmallShield());
        EquipmentType.addType(MiscType.createISLargeShield());
        EquipmentType.addType(MiscType.createISClaw());
        EquipmentType.addType(MiscType.createCLHarJel());
        EquipmentType.addType(MiscType.createISHarJel());
        EquipmentType.addType(MiscType.createISUMU());
        EquipmentType.addType(MiscType.createCLUMU());
        EquipmentType.addType(MiscType.createISLance());
        EquipmentType.addType(MiscType.createISWreckingBall());
        EquipmentType.addType(MiscType.createCLWreckingBall());
        EquipmentType.addType(MiscType.createISFlail());
        EquipmentType.addType(MiscType.createISMediumVibroblade());
        EquipmentType.addType(MiscType.createISSmallVibroblade());
        EquipmentType.addType(MiscType.createISLargeVibroblade());
        EquipmentType.addType(MiscType.createISBuzzsaw());
        EquipmentType.addType(MiscType.createCLBuzzsaw());
        EquipmentType.addType(MiscType.createCoolantSystem());
        EquipmentType.addType(MiscType.createHeavyArmor());
        EquipmentType.addType(MiscType.createSpikes());
        EquipmentType.addType(MiscType.createTalons());
        EquipmentType.addType(MiscType.createReactive());
        EquipmentType.addType(MiscType.createReflective());
        EquipmentType.addType(MiscType.createISCASEII());
        EquipmentType.addType(MiscType.createCLCASEII());
        EquipmentType.addType(MiscType.createISAES());
        EquipmentType.addType(MiscType.createCLAES());
        EquipmentType.addType(MiscType.createISModularArmor());
        EquipmentType.addType(MiscType.createCLModularArmor());
        EquipmentType.addType(MiscType.createCommsGear1());
        EquipmentType.addType(MiscType.createCommsGear2());
        EquipmentType.addType(MiscType.createCommsGear3());
        EquipmentType.addType(MiscType.createCommsGear4());
        EquipmentType.addType(MiscType.createCommsGear5());
        EquipmentType.addType(MiscType.createCommsGear6());
        EquipmentType.addType(MiscType.createCommsGear7());
        EquipmentType.addType(MiscType.createCommsGear8());
        EquipmentType.addType(MiscType.createCommsGear9());
        EquipmentType.addType(MiscType.createCommsGear10());
        EquipmentType.addType(MiscType.createCommsGear11());
        EquipmentType.addType(MiscType.createCommsGear12());
        EquipmentType.addType(MiscType.createCommsGear13());
        EquipmentType.addType(MiscType.createCommsGear14());
        EquipmentType.addType(MiscType.createCommsGear15());
        EquipmentType.addType(MiscType.createBABoardingClaw());
        EquipmentType.addType(MiscType.createBAAssaultClaws());
        EquipmentType.addType(MiscType.createBAFireResistantArmor());
        EquipmentType.addType(MiscType.createBasicStealth());
        EquipmentType.addType(MiscType.createStandardStealth());
        EquipmentType.addType(MiscType.createImprovedStealth());
        EquipmentType.addType(MiscType.createMine());
        EquipmentType.addType(MiscType.createMinesweeper());
        EquipmentType.addType(MiscType.createBAMagneticClamp());
        EquipmentType.addType(MiscType.createSingleHexECM());
        EquipmentType.addType(MiscType.createMimeticCamo());
        EquipmentType.addType(MiscType.createSimpleCamo());
        EquipmentType.addType(MiscType.createParafoil());
        EquipmentType.addType(MiscType.createSearchlight());
        EquipmentType.addType(MiscType.createISImprovedSensors());
        EquipmentType.addType(MiscType.createCLImprovedSensors());
        EquipmentType.addType(MiscType.createBAVibroClaw());
        EquipmentType.addType(MiscType.createCLBALightActiveProbe());
        EquipmentType.addType(MiscType.createISBALightActiveProbe());
        EquipmentType.addType(MiscType.createEnvironmentalSealing());
        EquipmentType.addType(MiscType.createTractorModification());
        EquipmentType.addType(MiscType.createArmoredChassis());
    }

    public static MiscType createHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000000000001L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Jump Jet";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("JumpJet");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000000000004L;
        miscType.subType |= 1L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createImprovedJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Improved Jump Jet";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("ImprovedJump Jet");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 2;
        miscType.flags |= 0x3000000000000004L;
        miscType.subType |= 2L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLImprovedJumpJet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Improved Jump Jet";
        miscType.setInternalName("Clan Improved Jump Jet");
        miscType.addLookupName("Clan Improved Jump Jet");
        miscType.addLookupName("CLImprovedJump Jet");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 2;
        miscType.flags |= 0x3000000000000004L;
        miscType.subType |= 2L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createTractorModification() {
        MiscType miscType = new MiscType();
        miscType.name = "Tractor Modification";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.cost = 0.0;
        miscType.flags |= 0x3000020000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createTreeClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Tree Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x2000000L;
        miscType.subType |= 3L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createGirderClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Girder Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x2000000L;
        miscType.subType |= 1L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createLimbClub() {
        MiscType miscType = new MiscType();
        miscType.name = "Limb Club";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x2000000L;
        miscType.subType |= 1L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createHatchet() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 0;
        miscType.name = "Hatchet";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 4L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createISDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Double Heat Sink";
        miscType.setInternalName("ISDoubleHeatSink");
        miscType.addLookupName("IS Double Heat Sink");
        miscType.addLookupName("ISDouble Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 3;
        miscType.flags |= 0x3000000000000002L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLDoubleHeatSink() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Double Heat Sink";
        miscType.setInternalName("CLDoubleHeatSink");
        miscType.addLookupName("Clan Double Heat Sink");
        miscType.addLookupName("CLDouble Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 2;
        miscType.flags |= 0x3000000000000002L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISCASE() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "CASE";
        miscType.setInternalName("ISCASE");
        miscType.addLookupName("IS CASE");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000000008L;
        miscType.cost = 50000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLCASE() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "CASE";
        miscType.setInternalName("CLCASE");
        miscType.addLookupName("Clan CASE");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000000008L;
        miscType.cost = 50000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISCASEII() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "CASE II";
        miscType.setInternalName("ISCASEII");
        miscType.addLookupName("IS CASE II");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.hittable = false;
        miscType.flags |= 0x3000002000000000L;
        miscType.cost = 175000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLCASEII() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "CASE II";
        miscType.setInternalName("CLCASEII");
        miscType.addLookupName("Clan CASE II");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.hittable = false;
        miscType.flags |= 0x3000002000000000L;
        miscType.cost = 175000.0;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISMASC() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "MASC";
        miscType.setInternalName("ISMASC");
        miscType.addLookupName("IS MASC");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3000000000000010L;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLMASC() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "MASC";
        miscType.setInternalName("CLMASC");
        miscType.addLookupName("Clan MASC");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000000000010L;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createISSuperCharger() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Supercharger";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS Super Charger");
        miscType.addLookupName("ISSuperCharger");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3000000000000010L;
        miscType.subType |= 1L;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLSuperCharger() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "Supercharger";
        miscType.setInternalName("CL Super Charger");
        miscType.addLookupName("CLSuperCharger");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3000000000000010L;
        miscType.subType |= 1L;
        miscType.bv = 0.0;
        String[] stringArray = new String[]{"Armed", "Off"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createTSM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "TSM";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS TSM");
        miscType.addLookupName("Triple Strength Myomer");
        miscType.tonnage = 0.0f;
        miscType.criticals = 6;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000000000020L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createIndustrialTSM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Industrial TSM";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS Industrial TSM");
        miscType.addLookupName("Industrial Triple Strength Myomer");
        miscType.tonnage = 0.0f;
        miscType.criticals = 12;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3002000000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3S() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "C3 Slave";
        miscType.setInternalName("ISC3SlaveUnit");
        miscType.addLookupName("IS C3 Slave");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 250000.0;
        miscType.flags |= 0x3000000000000080L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createC3I() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "C3i Computer";
        miscType.setInternalName("ISC3iUnit");
        miscType.addLookupName("ISImprovedC3CPU");
        miscType.addLookupName("IS C3i Computer");
        miscType.tonnage = 2.5f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.flags |= 0x3000000000000100L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISArtemis() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Artemis IV FCS";
        miscType.setInternalName("ISArtemisIV");
        miscType.addLookupName("IS Artemis IV FCS");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 100000.0;
        miscType.flags |= 0x3000000000000200L;
        return miscType;
    }

    public static MiscType createCLArtemis() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Artemis IV FCS";
        miscType.setInternalName("CLArtemisIV");
        miscType.addLookupName("Clan Artemis IV FCS");
        miscType.tonnage = 1.0f;
        miscType.cost = 100000.0;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000000000200L;
        return miscType;
    }

    public static MiscType createISApolloFCS() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "MRM Apollo FCS";
        miscType.setInternalName("ISApollo");
        miscType.addLookupName("IS MRM Apollo Fire Control System");
        miscType.addLookupName("IS MRM Apollo FCS");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 125000.0;
        miscType.flags |= 0x3001000000000000L;
        return miscType;
    }

    public static MiscType createGECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Guardian ECM Suite";
        miscType.setInternalName("ISGuardianECMSuite");
        miscType.addLookupName("IS Guardian ECM");
        miscType.addLookupName("ISGuardianECM");
        miscType.addLookupName("IS Guardian ECM Suite");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3000080000000000L;
        miscType.bv = 61.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCLECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "ECM Suite";
        miscType.setInternalName("CLECMSuite");
        miscType.addLookupName("Clan ECM Suite");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3000080000000000L;
        miscType.bv = 61.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createISAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Angel ECM Suite";
        miscType.setInternalName("ISAngelECMSuite");
        miscType.addLookupName("IS Angel ECM Suite");
        miscType.addLookupName("ISAngelECM");
        miscType.tonnage = 2.0f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.flags |= 0x3000080000000800L;
        miscType.bv = 100.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createISTHBAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 9;
        miscType.name = "THB Angel ECM Suite";
        miscType.setInternalName("ISTHBAngelECMSuite");
        miscType.addLookupName("IS THB Angel ECM Suite");
        miscType.addLookupName("ISTHBAngelECM");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 1000000.0;
        miscType.flags |= 0x3000080000000800L;
        miscType.bv = 100.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCLAngelECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "Angel ECM Suite";
        miscType.setInternalName("CLAngelECMSuite");
        miscType.addLookupName("Clan Angel ECM Suite");
        miscType.addLookupName("CLAngelECM");
        miscType.addLookupName("Clan Angel ECM Suite");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.flags |= 0x3000080000000800L;
        miscType.bv = 100.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createWatchdogECM() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "Watchdog ECM Suite";
        miscType.setInternalName("WatchdogECMSuite");
        miscType.addLookupName("Watchdog ECM Suite");
        miscType.addLookupName("WatchdogECM");
        miscType.addLookupName("CLWatchdogECM");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 500000.0;
        miscType.flags |= 0x3000180000000000L;
        miscType.bv = 73.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createSword() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Sword";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 8L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createChainWhip() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Chain Whip";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 3.0f;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = 120000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x1000000L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createRetractableBlade() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Retractable Blade";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x800000L;
        miscType.bv = -2.147483648E9;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{"retracted", "extended"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createSpotWelder() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Spot Welder";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 2.0f;
        miscType.criticals = 1;
        miscType.cost = 75000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x2000000L;
        miscType.bv = 5.0;
        return miscType;
    }

    public static MiscType createTHBMace() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 9;
        miscType.name = "Mace (THB)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("THB Mace");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x10L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createMace() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Mace";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = 130000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x40L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createBackhoe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Backhoe";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 5.0f;
        miscType.criticals = 6;
        miscType.cost = 50000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x40000L;
        miscType.bv = 8.0;
        return miscType;
    }

    public static MiscType createLiftHoist() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Lift Hoist";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 3.0f;
        miscType.criticals = 3;
        miscType.cost = 50000.0;
        miscType.flags |= 0x3000004000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createDualSaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Dual Saw";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 7.0f;
        miscType.criticals = 7;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x80L;
        miscType.bv = 9.0;
        return miscType;
    }

    public static MiscType createPileDriver() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Pile Driver";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("PileDriver");
        miscType.tonnage = 10.0f;
        miscType.criticals = 8;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x200L;
        miscType.bv = 5.0;
        return miscType;
    }

    public static MiscType createChainsaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Chainsaw";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 5.0f;
        miscType.criticals = 5;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x100000L;
        miscType.bv = 7.0;
        return miscType;
    }

    public static MiscType createRockCutter() {
        MiscType miscType = new MiscType();
        miscType.techLevel = -2;
        miscType.name = "Rock Cutter";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 5.0f;
        miscType.criticals = 5;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x200000L;
        miscType.bv = 6.0;
        return miscType;
    }

    public static MiscType createEjectionSeat() {
        MiscType miscType = new MiscType();
        miscType.name = "Ejection Seat";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.cost = 0.0;
        miscType.flags |= 0x3080000000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createArmoredChassis() {
        MiscType miscType = new MiscType();
        miscType.name = "Armored Chassis";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.cost = 0.0;
        miscType.flags |= 0x2000010000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createArmoredCowl() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 9;
        miscType.name = "Armored Cowl";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 10000.0;
        miscType.flags |= 0x3000000008000000L;
        miscType.bv = 10.0;
        return miscType;
    }

    public static MiscType createISTargComp() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Targeting Computer";
        miscType.setInternalName("ISTargeting Computer");
        miscType.addLookupName("IS Targeting Computer");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x3000000000000400L;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Normal", "Aimed shot"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createCLTargComp() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Targeting Computer";
        miscType.setInternalName("CLTargeting Computer");
        miscType.addLookupName("Clan Targeting Computer");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.bv = -2.147483648E9;
        miscType.flags |= 0x3000000000000400L;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Normal", "Aimed shot"};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createBABoardingClaw() {
        MiscType miscType = new MiscType();
        miscType.name = "Boarding Claw";
        miscType.setInternalName("BA-Boarding Claw");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000001000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBAAssaultClaws() {
        MiscType miscType = new MiscType();
        miscType.name = "Assault Claws";
        miscType.setInternalName("BA-Assault Claws");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000004000L;
        miscType.bv = 3.0;
        return miscType;
    }

    public static MiscType createBAFireResistantArmor() {
        MiscType miscType = new MiscType();
        miscType.name = "Fire Resistant Armor";
        miscType.setInternalName("BA-Fire Resistant Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000008000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBasicStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Basic Stealth";
        miscType.setInternalName("Basic Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000010000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createStandardStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Standard Stealth";
        miscType.setInternalName("Standard Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000010000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createImprovedStealth() {
        MiscType miscType = new MiscType();
        miscType.name = "Improved Stealth";
        miscType.setInternalName("Improved Stealth");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000010000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMine() {
        MiscType miscType = new MiscType();
        miscType.name = "Mine";
        miscType.setInternalName("Mine");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.flags |= 0x800000000020000L;
        miscType.bv = 4.0;
        return miscType;
    }

    public static MiscType createMinesweeper() {
        MiscType miscType = new MiscType();
        miscType.name = "Minesweeper";
        miscType.setInternalName("Minesweeper");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x40000L;
        miscType.subType |= 8L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createLightMinesweeper() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Light Minesweeper";
        miscType.setInternalName("Light Minesweeper");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x40000L;
        miscType.subType |= 8L;
        miscType.toHitModifier = 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBAMagneticClamp() {
        MiscType miscType = new MiscType();
        miscType.name = "Magnetic Clamp";
        miscType.setInternalName("BA-Magnetic Clamp");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800000000080000L;
        String[] stringArray = new String[]{"On", "Off"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(true);
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createSingleHexECM() {
        MiscType miscType = new MiscType();
        miscType.name = "Single-Hex ECM";
        miscType.setInternalName("Single-Hex ECM");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x840080000000000L;
        miscType.bv = 0.0;
        miscType.setModes(new String[]{"ECM"});
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createMimeticCamo() {
        MiscType miscType = new MiscType();
        miscType.name = "Mimetic Armor";
        miscType.setInternalName("Mimetic Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800800000010000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createSimpleCamo() {
        MiscType miscType = new MiscType();
        miscType.name = "Simple Camo";
        miscType.setInternalName("Simple Camo");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x800800000010000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createParafoil() {
        MiscType miscType = new MiscType();
        miscType.name = "Parafoil";
        miscType.setInternalName("Parafoil");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000100000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createMekStealth() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(8);
        miscType.setInternalName(EquipmentType.getArmorTypeName(8));
        miscType.addLookupName("Stealth Armor");
        miscType.tonnage = 0.0f;
        miscType.criticals = 12;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x1000000000010000L;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createNullSignatureSystem() {
        MiscType miscType = new MiscType();
        miscType.name = "Null Signature System";
        miscType.setInternalName("Mek Null Signature System");
        miscType.addLookupName("Null Signature System");
        miscType.addLookupName("NullSignatureSystem");
        miscType.tonnage = 0.0f;
        miscType.criticals = 7;
        miscType.spreadable = true;
        miscType.flags |= 0x1004000000000000L;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createVoidSignatureSystem() {
        MiscType miscType = new MiscType();
        miscType.name = "Void Signature System";
        miscType.setInternalName("Mek Void Signature System");
        miscType.addLookupName("Void Signature System");
        miscType.addLookupName("VoidSignatureSystem");
        miscType.tonnage = 0.0f;
        miscType.criticals = 7;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.flags |= 0x1008000000000000L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createChameleonLightPolarizationField() {
        MiscType miscType = new MiscType();
        miscType.name = "Chameleon Light Polarization Field";
        miscType.setInternalName("Chameleon Light Polarization Field");
        miscType.addLookupName("Chameleon Light Polarization Field");
        miscType.addLookupName("ChameleonLightPolarizationField");
        miscType.tonnage = 0.0f;
        miscType.criticals = 6;
        miscType.spreadable = true;
        String[] stringArray = new String[]{"Off", "On"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        miscType.flags |= 0x1010000000000000L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(1);
        miscType.setInternalName(EquipmentType.getArmorTypeName(1));
        miscType.addLookupName("Ferro-Fibrous Armor");
        miscType.addLookupName("Ferro Fibre");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000000200000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createFerroFibrousPrototype() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(9);
        miscType.setInternalName(EquipmentType.getArmorTypeName(9));
        miscType.addLookupName("Ferro-Fibrous Armor Prototype");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 16;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000000200000L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createLightFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(5);
        miscType.setInternalName(EquipmentType.getArmorTypeName(5));
        miscType.addLookupName("Light Ferro-Fibrous Armor");
        miscType.addLookupName("LightFerro");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 7;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000000200000L;
        miscType.bv = 0.0;
        miscType.techLevel = 1;
        return miscType;
    }

    public static MiscType createHeavyFerroFibrous() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(6);
        miscType.setInternalName(EquipmentType.getArmorTypeName(6));
        miscType.addLookupName("Heavy Ferro-Fibrous Armor");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 21;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000000200000L;
        miscType.bv = 0.0;
        miscType.techLevel = 1;
        return miscType;
    }

    public static MiscType createHardenedArmor() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(4);
        miscType.setInternalName(EquipmentType.getArmorTypeName(4));
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000000000000L;
        return miscType;
    }

    public static MiscType createCommercialArmor() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(10);
        miscType.setInternalName(EquipmentType.getArmorTypeName(10));
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000000000000L;
        return miscType;
    }

    public static MiscType createIndustrialArmor() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(14);
        miscType.setInternalName(EquipmentType.getArmorTypeName(14));
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000000000000L;
        return miscType;
    }

    public static MiscType createHeavyIndustrialArmor() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(15);
        miscType.setInternalName(EquipmentType.getArmorTypeName(15));
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000000000000L;
        return miscType;
    }

    public static MiscType createEndoSteel() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(1);
        miscType.setInternalName(EquipmentType.getStructureTypeName(1));
        miscType.addLookupName("Endo-Steel");
        miscType.addLookupName("EndoSteel");
        miscType.techLevel = -2;
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x1000000000400000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createEndoSteelPrototype() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(2);
        miscType.setInternalName(EquipmentType.getStructureTypeName(2));
        miscType.addLookupName("Endo-Steel Prototype");
        miscType.addLookupName("EndoSteelPrototype");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 16;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x1000000000400000L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createReinforcedStructure() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(3);
        miscType.setInternalName(EquipmentType.getStructureTypeName(3));
        miscType.addLookupName("Reinforced");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        miscType.flags |= 0x3000000000000000L;
        return miscType;
    }

    public static MiscType createCommsGear1() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (1 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:1");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear2() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (2 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:2");
        miscType.tonnage = 2.0f;
        miscType.criticals = 2;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear3() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (3 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:3");
        miscType.tonnage = 3.0f;
        miscType.criticals = 3;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear4() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (4 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:4");
        miscType.tonnage = 4.0f;
        miscType.criticals = 4;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear5() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (5 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:51");
        miscType.tonnage = 5.0f;
        miscType.criticals = 5;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear6() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (6 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:6");
        miscType.tonnage = 6.0f;
        miscType.criticals = 6;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear7() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (7 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:7");
        miscType.tonnage = 7.0f;
        miscType.criticals = 7;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear8() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (8 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:8");
        miscType.tonnage = 8.0f;
        miscType.criticals = 8;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear9() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (9 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:9");
        miscType.tonnage = 9.0f;
        miscType.criticals = 9;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear10() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (10 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:10");
        miscType.tonnage = 10.0f;
        miscType.criticals = 10;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear11() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (11 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:11");
        miscType.tonnage = 11.0f;
        miscType.criticals = 11;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear12() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (12 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:12");
        miscType.tonnage = 12.0f;
        miscType.criticals = 12;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear13() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (13 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:13");
        miscType.tonnage = 13.0f;
        miscType.criticals = 13;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear14() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (14 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:14");
        miscType.tonnage = 14.0f;
        miscType.criticals = 14;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCommsGear15() {
        MiscType miscType = new MiscType();
        miscType.name = "Communications Equipment (15 ton)";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CommsGear:15");
        miscType.tonnage = 15.0f;
        miscType.criticals = 15;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000200000000L;
        miscType.techLevel = -2;
        String[] stringArray = new String[]{"Default", "ECCM", "Ghost Targets"};
        miscType.setModes(stringArray);
        miscType.setInstantModeSwitch(false);
        return miscType;
    }

    public static MiscType createCompositeStructure() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(4);
        miscType.setInternalName(EquipmentType.getStructureTypeName(4));
        miscType.addLookupName("Composite");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createIndustrialStructure() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(5);
        miscType.setInternalName(EquipmentType.getStructureTypeName(5));
        miscType.addLookupName("Industrial");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.bv = 0.0;
        miscType.techLevel = 4;
        return miscType;
    }

    public static MiscType createCLLaserHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "Laser Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("CLLaser Heat Sink");
        miscType.tonnage = 1.0f;
        miscType.criticals = 2;
        miscType.flags |= 0x3000000000000042L;
        miscType.bv = 0.0;
        miscType.techLevel = 6;
        return miscType;
    }

    public static MiscType createIS1CompactHeatSink() {
        MiscType miscType = new MiscType();
        miscType.name = "1 Compact Heat Sink";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS1 Compact Heat Sink");
        miscType.tonnage = 1.5f;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000000000001L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createIS2CompactHeatSinks() {
        MiscType miscType = new MiscType();
        miscType.name = "2 Compact Heat Sinks";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS2 Compact Heat Sinks");
        miscType.tonnage = 3.0f;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000000000002L;
        miscType.bv = 0.0;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createISImprovedSensors() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Improved Sensors";
        miscType.setInternalName("ISImprovedSensors");
        miscType.addLookupName("BAP (2 Hex)");
        miscType.tonnage = 0.0f;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3800100000000000L;
        return miscType;
    }

    public static MiscType createCLImprovedSensors() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Improved Sensors";
        miscType.setInternalName("CLImprovedSensors");
        miscType.addLookupName("BAP (3 Hex)");
        miscType.tonnage = 0.0f;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3800100000000000L;
        return miscType;
    }

    public static MiscType createBeagleActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Beagle Active Probe";
        miscType.setInternalName("BeagleActiveProbe");
        miscType.addLookupName("Beagle Active Probe");
        miscType.addLookupName("ISBeagleActiveProbe");
        miscType.addLookupName("IS Beagle Active Probe");
        miscType.tonnage = 1.5f;
        miscType.criticals = 2;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3000100000000000L;
        miscType.bv = 10.0;
        return miscType;
    }

    public static MiscType createBloodhoundActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Bloodhound Active Probe";
        miscType.setInternalName("BloodhoundActiveProbe");
        miscType.addLookupName("Bloodhound Active Probe");
        miscType.addLookupName("ISBloodhoundActiveProbe");
        miscType.addLookupName("IS Bloodhound Active Probe");
        miscType.tonnage = 2.0f;
        miscType.criticals = 3;
        miscType.cost = 500000.0;
        miscType.flags |= 0x3000100000000000L;
        miscType.bv = 25.0;
        return miscType;
    }

    public static MiscType createTHBBloodhoundActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 9;
        miscType.name = "Bloodhound Active Probe (THB)";
        miscType.setInternalName("THBBloodhoundActiveProbe");
        miscType.addLookupName("THB Bloodhound Active Probe");
        miscType.addLookupName("ISTHBBloodhoundActiveProbe");
        miscType.addLookupName("IS THB Bloodhound Active Probe");
        miscType.tonnage = 5.0f;
        miscType.criticals = 2;
        miscType.cost = 750000.0;
        miscType.flags |= 0x3000100000000000L;
        miscType.bv = 25.0;
        return miscType;
    }

    public static MiscType createCLActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Active Probe";
        miscType.setInternalName("CLActiveProbe");
        miscType.addLookupName("Active Probe");
        miscType.addLookupName("Clan Active Probe");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 200000.0;
        miscType.flags |= 0x3000100000000000L;
        miscType.bv = 12.0;
        return miscType;
    }

    public static MiscType createCLLightActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.name = "Light Active Probe";
        miscType.techLevel = 2;
        miscType.setInternalName("CLLightActiveProbe");
        miscType.addLookupName("CL Light Active Probe");
        miscType.addLookupName("Light Active Probe");
        miscType.addLookupName("Clan Light Active Probe");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.cost = 150000.0;
        miscType.flags |= 0x3000100000000000L;
        miscType.bv = 7.0;
        return miscType;
    }

    public static MiscType createCLBALightActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.name = "Light Active Probe";
        miscType.techLevel = 2;
        miscType.setInternalName("CLBALightActiveProbe");
        miscType.tonnage = 0.15f;
        miscType.criticals = 1;
        miscType.cost = 50000.0;
        miscType.flags |= 0x3800100000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISBALightActiveProbe() {
        MiscType miscType = new MiscType();
        miscType.name = "Light Active Probe";
        miscType.techLevel = 1;
        miscType.setInternalName("ISBALightActiveProbe");
        miscType.tonnage = 0.25f;
        miscType.criticals = 1;
        miscType.cost = 50000.0;
        miscType.flags |= 0x3800100000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISAPPod() {
        MiscType miscType = new MiscType();
        miscType.name = "A-Pod";
        miscType.techLevel = 1;
        miscType.setInternalName("ISAntiPersonnelPod");
        miscType.addLookupName("ISAPod");
        miscType.addLookupName("IS A-Pod");
        miscType.addLookupName("IS AP Pod");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.cost = 1500.0;
        miscType.flags |= 0x3000000000800000L;
        miscType.bv = 1.0;
        return miscType;
    }

    public static MiscType createCLAPPod() {
        MiscType miscType = new MiscType();
        miscType.name = "A-Pod";
        miscType.techLevel = 2;
        miscType.setInternalName("CLAntiPersonnelPod");
        miscType.addLookupName("Clan A-Pod");
        miscType.addLookupName("CL AP Pod");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.cost = 1500.0;
        miscType.flags |= 0x3000000000800000L;
        miscType.bv = 1.0;
        return miscType;
    }

    public static MiscType createSearchlight() {
        MiscType miscType = new MiscType();
        miscType.name = "Searchlight";
        miscType.setInternalName("Searchlight");
        miscType.addLookupName("BASearchlight");
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000001000000L;
        miscType.bv = 0.0;
        miscType.cost = 2000.0;
        return miscType;
    }

    public static MiscType createBAVibroClaw() {
        MiscType miscType = new MiscType();
        miscType.name = "Vibroclaw";
        miscType.setInternalName("BAVibroClaw");
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x20000000000000L;
        miscType.bv = 1.0;
        return miscType;
    }

    public static MiscType createVacuumProtection() {
        MiscType miscType = new MiscType();
        miscType.name = "Vacuum Protection";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 0;
        miscType.cost = 0.0;
        miscType.flags |= 0x3000000000002000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createEnvironmentalSealing() {
        MiscType miscType = new MiscType();
        miscType.name = "Environmental Sealing";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 8;
        miscType.cost = 0.0;
        miscType.spreadable = true;
        miscType.flags |= 0x3000008000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createJumpBooster() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Jump Booster";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.bv = 0.0;
        miscType.flags |= 0x3000000010000000L;
        miscType.spreadable = true;
        return miscType;
    }

    public static MiscType createDemolitionCharge() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Demolition Charge";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000040000L;
        miscType.subType |= 2L;
        miscType.toHitModifier = 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createVibroShovel() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Vibro-Shovel";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000040000L;
        miscType.subType |= 1L;
        miscType.toHitModifier = 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createBridgeKit() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Bridge Kit";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.hittable = false;
        miscType.flags |= 0x3000000000040000L;
        miscType.subType |= 4L;
        miscType.toHitModifier = 1;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISSmallShield() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Small Shield";
        miscType.setInternalName("ISSmallShield");
        miscType.addLookupName("Small Shield");
        miscType.tonnage = 2.0f;
        miscType.criticals = 3;
        miscType.cost = 50000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x400L;
        miscType.bv = 50.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{S_NO_SHIELD, S_ACTIVE_SHIELD, S_PASSIVE_SHIELD};
        miscType.setModes(stringArray);
        miscType.damageTaken = 0;
        miscType.baseDamageAbsorptionRate = 3;
        miscType.baseDamageCapacity = 11;
        return miscType;
    }

    public static MiscType createISClaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Claw";
        miscType.setInternalName("ISClaw");
        miscType.addLookupName("Claw");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000004000000L;
        miscType.subType |= 1L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createISMediumShield() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Medium Shield";
        miscType.setInternalName("ISMediumShield");
        miscType.addLookupName("Medium Shield");
        miscType.tonnage = 4.0f;
        miscType.criticals = 5;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x800L;
        miscType.bv = 135.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{S_NO_SHIELD, S_ACTIVE_SHIELD, S_PASSIVE_SHIELD};
        miscType.setModes(stringArray);
        miscType.damageTaken = 0;
        miscType.baseDamageAbsorptionRate = 5;
        miscType.baseDamageCapacity = 18;
        return miscType;
    }

    public static MiscType createISLargeShield() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Large Shield";
        miscType.setInternalName("ISLargeShield");
        miscType.addLookupName("Large Shield");
        miscType.tonnage = 6.0f;
        miscType.criticals = 7;
        miscType.cost = 300000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x1000L;
        miscType.bv = 263.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{S_NO_SHIELD, S_ACTIVE_SHIELD, S_PASSIVE_SHIELD};
        miscType.setModes(stringArray);
        miscType.damageTaken = 0;
        miscType.baseDamageAbsorptionRate = 7;
        miscType.baseDamageCapacity = 25;
        return miscType;
    }

    public static MiscType createCLHarJel() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "HarJel";
        miscType.setInternalName("Clan HarJel");
        miscType.addLookupName("Clan HarJel");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 120000.0;
        miscType.flags |= 0x3000000020000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISHarJel() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "HarJel";
        miscType.setInternalName("IS HarJel");
        miscType.addLookupName("IS HarJel");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 120000.0;
        miscType.flags |= 0x3000000020000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISAES() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "AES";
        miscType.setInternalName("ISAES");
        miscType.addLookupName("IS Actuator Enhancement System");
        miscType.addLookupName("ISActuatorEnhancementSystem");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3000040000000000L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createCLAES() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "AES";
        miscType.setInternalName("CLAES");
        miscType.addLookupName("CL Actuator Enhancement System");
        miscType.addLookupName("CLActuatorEnhancementSystem");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3000040000000000L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createISUMU() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "UMU";
        miscType.setInternalName("ISUMU");
        miscType.addLookupName("IS Underwater Maneuvering Unit");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000040000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createCLUMU() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "UMU";
        miscType.setInternalName("CLUMU");
        miscType.addLookupName("Clan Underwater Maneuvering Unit");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = 1;
        miscType.flags |= 0x3000000040000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISLance() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Lance";
        miscType.setInternalName("IS Lance");
        miscType.addLookupName("ISLance");
        miscType.addLookupName("Lance");
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x2000L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createISFlail() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Flail";
        miscType.setInternalName("IS Flail");
        miscType.addLookupName("Flail");
        miscType.tonnage = 5.0f;
        miscType.criticals = 4;
        miscType.cost = 110000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x100L;
        miscType.bv = 11.0;
        return miscType;
    }

    public static MiscType createISWreckingBall() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "Wrecking Ball";
        miscType.setInternalName("IS Wrecking Ball");
        miscType.addLookupName("WreckingBall");
        miscType.tonnage = 4.0f;
        miscType.criticals = 5;
        miscType.cost = 110000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x20000L;
        miscType.bv = 8.0;
        return miscType;
    }

    public static MiscType createCLWreckingBall() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 2;
        miscType.name = "Wrecking Ball";
        miscType.setInternalName("Clan Wrecking Ball");
        miscType.addLookupName("CLWrecking Ball");
        miscType.tonnage = 4.0f;
        miscType.criticals = 5;
        miscType.cost = 110000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x20000L;
        miscType.bv = 8.0;
        return miscType;
    }

    public static MiscType createISSmallVibroblade() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Small Vibroblade";
        miscType.setInternalName("ISSmallVibroblade");
        miscType.addLookupName("Small Vibroblade");
        miscType.tonnage = 3.0f;
        miscType.criticals = 1;
        miscType.cost = 150000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x4000L;
        miscType.bv = 12.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{"Inactive", S_ACTIVE_SHIELD};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createISMediumVibroblade() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Medium Vibroblade";
        miscType.setInternalName("ISMediumVibroblade");
        miscType.addLookupName("Medium Vibroblade");
        miscType.tonnage = 5.0f;
        miscType.criticals = 2;
        miscType.cost = 400000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x8000L;
        miscType.bv = 17.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{"Inactive", S_ACTIVE_SHIELD};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createISLargeVibroblade() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Large Vibroblade";
        miscType.setInternalName("ISLargeVibroblade");
        miscType.addLookupName("Large Vibroblade");
        miscType.tonnage = 7.0f;
        miscType.criticals = 4;
        miscType.cost = 750000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x10000L;
        miscType.bv = 24.0;
        miscType.setInstantModeSwitch(true);
        String[] stringArray = new String[]{"Inactive", S_ACTIVE_SHIELD};
        miscType.setModes(stringArray);
        return miscType;
    }

    public static MiscType createISBuzzsaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Buzzsaw";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("IS Buzzsaw");
        miscType.tonnage = 4.0f;
        miscType.criticals = 2;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x400000L;
        miscType.bv = 67.0;
        return miscType;
    }

    public static MiscType createCLBuzzsaw() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "Buzzsaw";
        miscType.setInternalName("CLBuzzsaw");
        miscType.addLookupName("Clan Buzzsaw");
        miscType.tonnage = 4.0f;
        miscType.criticals = 2;
        miscType.cost = 100000.0;
        miscType.flags |= 0x1000000002000000L;
        miscType.subType |= 0x400000L;
        miscType.bv = 6.0;
        return miscType;
    }

    public static MiscType createCoolantSystem() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Coolant System";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 9.0f;
        miscType.criticals = 2;
        miscType.cost = 90000.0;
        miscType.flags |= 0x3000000080000000L;
        miscType.bv = 15.0;
        return miscType;
    }

    public static MiscType createSpikes() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Spikes";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.5f;
        miscType.criticals = 1;
        miscType.cost = 90000.0;
        miscType.flags |= 0x3000000100000000L;
        miscType.bv = 3.0;
        return miscType;
    }

    public static MiscType createTalons() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 6;
        miscType.name = "Talons";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.spreadable = true;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x1000400000000000L;
        miscType.bv = -2.147483648E9;
        return miscType;
    }

    public static MiscType createHeavyArmor() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 5;
        miscType.name = "Heavy Armor";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = 0.0f;
        miscType.criticals = 0;
        miscType.cost = 100000.0;
        miscType.flags |= 0x40000L;
        miscType.subType = 16L;
        miscType.bv = 15.0;
        return miscType;
    }

    public static MiscType createStandard() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getStructureTypeName(0);
        miscType.setInternalName(EquipmentType.getStructureTypeName(0));
        miscType.addLookupName("Regular");
        miscType.addLookupName("Standard Armor");
        return miscType;
    }

    public static MiscType createISPPCCapacitor() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 1;
        miscType.name = "PPC Capacitor";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("ISPPCCapacitor");
        miscType.addLookupName("LPPC Capacitor");
        miscType.addLookupName("ISLightPPCCapacitor");
        miscType.addLookupName("SNPPC Capacitor");
        miscType.addLookupName("ISSNPPCCapacitor");
        miscType.addLookupName("ERPPC Capacitor");
        miscType.addLookupName("ISERPPCCapacitor");
        miscType.addLookupName("HPPC Capacitor");
        miscType.addLookupName("ISHeavyPPCCapacitor");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 150000.0;
        miscType.setModes(new String[]{"Off", "Charge"});
        miscType.flags |= 0x3000000400000000L;
        miscType.setInstantModeSwitch(false);
        miscType.explosive = true;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createReflective() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(3);
        miscType.setInternalName(EquipmentType.getArmorTypeName(3));
        miscType.addLookupName("Reflective Armor");
        miscType.addLookupName("Reflective");
        miscType.tonnage = 0.0f;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.hittable = false;
        miscType.spreadable = true;
        miscType.flags |= 0x3000000800000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createReactive() {
        MiscType miscType = new MiscType();
        miscType.name = EquipmentType.getArmorTypeName(2);
        miscType.setInternalName(EquipmentType.getArmorTypeName(2));
        miscType.addLookupName("Reactive Armor");
        miscType.addLookupName("Reactive");
        miscType.tonnage = 0.0f;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.spreadable = true;
        miscType.flags |= 0x3000001000000000L;
        miscType.bv = 0.0;
        return miscType;
    }

    public static MiscType createISModularArmor() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 7;
        miscType.name = "Modular Armor";
        miscType.setInternalName("ISModularArmor");
        miscType.setInternalName("IS Modular Armor");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 100000.0;
        miscType.flags |= 0x3000200000000000L;
        miscType.bv = -2.147483648E9;
        miscType.damageTaken = 0;
        miscType.baseDamageAbsorptionRate = 10;
        miscType.baseDamageCapacity = 10;
        return miscType;
    }

    public static MiscType createCLModularArmor() {
        MiscType miscType = new MiscType();
        miscType.techLevel = 8;
        miscType.name = "Modular Armor";
        miscType.setInternalName("CLModularArmor");
        miscType.addLookupName("Clan Modular Armor");
        miscType.tonnage = 1.0f;
        miscType.criticals = 1;
        miscType.cost = 100000.0;
        miscType.flags |= 0x3000200000000000L;
        miscType.bv = -2.147483648E9;
        miscType.damageTaken = 0;
        miscType.baseDamageAbsorptionRate = 10;
        miscType.baseDamageCapacity = 10;
        return miscType;
    }

    public static MiscType createSalvageArm() {
        MiscType miscType = new MiscType();
        miscType.name = "Salvage Arm";
        miscType.setInternalName(miscType.name);
        miscType.addLookupName("SalvageArm");
        miscType.tonnage = 3.0f;
        miscType.criticals = 2;
        miscType.bv = 0.0;
        miscType.cost = 50000.0;
        miscType.flags |= 0x3100000000000000L;
        miscType.techLevel = -2;
        return miscType;
    }

    public static MiscType createTracks() {
        MiscType miscType = new MiscType();
        miscType.name = "Tracks";
        miscType.setInternalName(miscType.name);
        miscType.tonnage = Float.MIN_VALUE;
        miscType.criticals = Integer.MIN_VALUE;
        miscType.spreadable = true;
        miscType.bv = 0.0;
        miscType.cost = -2.147483648E9;
        miscType.flags |= 0x3200000000000000L;
        miscType.techLevel = -2;
        return miscType;
    }

    public static MiscType createISMASS() {
        MiscType miscType = new MiscType();
        miscType.name = "MASS";
        miscType.setInternalName("ISMASS");
        miscType.addLookupName("IS Mass");
        miscType.tonnage = 1.5f;
        miscType.criticals = 1;
        miscType.bv = 9.0;
        miscType.cost = 4000.0;
        miscType.flags |= 0x3400000000000000L;
        miscType.techLevel = 7;
        return miscType;
    }

    public static MiscType createCLMASS() {
        MiscType miscType = new MiscType();
        miscType.name = "MASS";
        miscType.setInternalName("CLMASS");
        miscType.addLookupName("Clan Mass");
        miscType.tonnage = 1.5f;
        miscType.criticals = 1;
        miscType.bv = 9.0;
        miscType.cost = 4000.0;
        miscType.flags |= 0x3400000000000000L;
        miscType.techLevel = 8;
        return miscType;
    }

    public static String getTargetSysName(int n) {
        if (n < 0 || n >= targSysNames.length) {
            return null;
        }
        return targSysNames[n];
    }

    public static int getTargetSysType(String string) {
        for (int i = 0; i < targSysNames.length; ++i) {
            if (targSysNames[i].compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }
}

