/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKBattleArmorFile
extends BLKFile
implements IMechLoader {
    public BLKBattleArmorFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        BattleArmor battleArmor = new BattleArmor();
        if (!this.dataFile.exists("name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        battleArmor.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            battleArmor.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            battleArmor.setModel("");
        }
        this.setTechLevel(battleArmor);
        if (this.dataFile.exists("source")) {
            battleArmor.setSource(this.dataFile.getDataAsString("source")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        battleArmor.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = -1;
        if (string.equalsIgnoreCase("leg")) {
            n = 10;
        } else if (string.equalsIgnoreCase("jump")) {
            n = 12;
        } else if (string.equalsIgnoreCase("vtol")) {
            n = 6;
        } else if (string.equalsIgnoreCase("submarine")) {
            n = 18;
        }
        if (n == -1) {
            throw new EntityLoadingException("Invalid movement type: " + string);
        }
        battleArmor.setMovementMode(n);
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        battleArmor.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (this.dataFile.exists("jumpingMP")) {
            battleArmor.setOriginalJumpMP(this.dataFile.getDataAsInt("jumpingMP")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 1) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        battleArmor.refreshLocations();
        for (int i = 1; i < battleArmor.locations(); ++i) {
            battleArmor.initializeArmor(nArray[0], i);
        }
        battleArmor.autoSetInternal();
        this.loadEquipment(battleArmor, "Squad", 0);
        String[] stringArray = battleArmor.getLocationAbbrs();
        for (int i = 1; i < battleArmor.locations(); ++i) {
            this.loadEquipment(battleArmor, stringArray[i], i);
        }
        return battleArmor;
    }

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = stringArray[i].endsWith(":Body");
                stringArray[i] = stringArray[i].replace(":Body", "");
                String string3 = stringArray[i].trim();
                EquipmentType equipmentType = EquipmentType.get(string3);
                if (equipmentType == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n, false, bl);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }
}

