/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.util.Vector;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.SupportTank;
import megamek.common.TroopSpace;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKSupportTankFile
extends BLKFile
implements IMechLoader {
    protected static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "", "Naval", "Hydrofoil", "Submarine", "", "", "", "", "", "WiGE"};

    public BLKSupportTankFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        SupportTank supportTank = new SupportTank();
        if (!this.dataFile.exists("barrating")) {
            throw new EntityLoadingException("Could not find barrating block.");
        }
        supportTank.setBARRating(this.dataFile.getDataAsInt("barrating")[0]);
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        supportTank.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            supportTank.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            supportTank.setModel("");
        }
        this.setTechLevel(supportTank);
        if (this.dataFile.exists("source")) {
            supportTank.setSource(this.dataFile.getDataAsString("source")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        supportTank.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n2 = -1;
        for (n = 0; n < MOVES.length; ++n) {
            if (!string.equalsIgnoreCase(MOVES[n])) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        supportTank.setMovementMode(n2);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray;
            for (String object2 : stringArray = this.dataFile.getDataAsString("transporters")) {
                if (!object2.startsWith("TroopSpace:", 0)) continue;
                Double i = new Double(object2.substring(11));
                int n3 = i.intValue();
                supportTank.addTransporter(new TroopSpace(n3));
            }
        }
        n = 0;
        if (this.dataFile.exists("engine_type")) {
            n = this.dataFile.getDataAsInt("engine_type")[0];
        }
        int n4 = 2;
        if (supportTank.isClan()) {
            n4 |= 1;
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        int n5 = this.dataFile.getDataAsInt("cruiseMP")[0] * (int)supportTank.getWeight() - supportTank.getSuspensionFactor();
        supportTank.setEngine(new Engine(n5, BLKFile.translateEngineCode(n), n4));
        if (this.dataFile.exists("armor_type")) {
            supportTank.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            supportTank.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            supportTank.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 4 || nArray.length > 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        supportTank.setHasNoTurret(nArray.length == 4);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            supportTank.initializeArmor(nArray2[i], i);
        }
        supportTank.autoSetInternal();
        this.loadEquipment(supportTank, "Front", 1);
        this.loadEquipment(supportTank, "Right", 2);
        this.loadEquipment(supportTank, "Left", 3);
        this.loadEquipment(supportTank, "Rear", 4);
        if (!supportTank.hasNoTurret()) {
            this.loadEquipment(supportTank, "Turret", 5);
        }
        this.loadEquipment(supportTank, "Body", 0);
        if (this.dataFile.exists("omni")) {
            supportTank.setOmni(true);
        }
        return supportTank;
    }

    public static void encode(String string, SupportTank supportTank) {
        String string2;
        BuildingBlock buildingBlock = new BuildingBlock();
        buildingBlock.createNewBlock();
        buildingBlock.writeBlockData("UnitType", "SupportTank");
        buildingBlock.writeBlockData("blockversion", 1);
        buildingBlock.writeBlockData("Name", supportTank.getChassis());
        buildingBlock.writeBlockData("Model", supportTank.getModel());
        buildingBlock.writeBlockData("year", supportTank.getYear());
        if (supportTank.isMixedTech()) {
            string2 = !supportTank.isClan() ? "Mixed (IS Chassis)" : "Mixed (Clan Chassis)";
        } else {
            switch (supportTank.getTechLevel()) {
                case 0: {
                    string2 = "IS Level 1";
                    break;
                }
                case 1: {
                    string2 = "IS Level 2";
                    break;
                }
                default: {
                    string2 = "IS Level 3";
                    break;
                }
                case 2: {
                    string2 = "Clan Level 2";
                    break;
                }
                case 6: {
                    string2 = "Clan Level 3";
                }
            }
        }
        buildingBlock.writeBlockData("type", string2);
        buildingBlock.writeBlockData("tonnage", supportTank.getWeight());
        buildingBlock.writeBlockData("motion_type", supportTank.getMovementModeAsString());
        if (supportTank.getTroopCarryingSpace() > 0) {
            buildingBlock.writeBlockData("transporters", "TroopSpace: " + supportTank.getTroopCarryingSpace());
        }
        int n = 0;
        switch (supportTank.getEngine().getEngineType()) {
            case 0: {
                n = 1;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            case 7: {
                n = 7;
            }
        }
        buildingBlock.writeBlockData("engine_type", n);
        buildingBlock.writeBlockData("cruiseMP", supportTank.getOriginalWalkMP());
        if (supportTank.getArmorType() != 0) {
            buildingBlock.writeBlockData("armor_type", supportTank.getArmorType());
            buildingBlock.writeBlockData("armor_tech", supportTank.getArmorTechLevel());
        }
        if (supportTank.getStructureType() != 0) {
            buildingBlock.writeBlockData("internal_type", supportTank.getStructureType());
        }
        if (supportTank.isOmni()) {
            buildingBlock.writeBlockData("omni", 1);
        }
        int[] nArray = new int[supportTank.locations() - 1];
        for (int i = 1; i < supportTank.locations(); ++i) {
            nArray[i - 1] = supportTank.getOArmor(i);
        }
        buildingBlock.writeBlockData("armor", nArray);
        Vector vector = new Vector(supportTank.locations());
        for (int i = 0; i < supportTank.locations(); ++i) {
            vector.add(new Vector());
        }
        for (Mounted mounted : supportTank.getEquipment()) {
            String string3 = mounted.getType().getInternalName();
            int n2 = mounted.getLocation();
            if (n2 == -1) continue;
            ((Vector)vector.get(n2)).add(string3);
        }
        for (int i = 0; i < supportTank.locations(); ++i) {
            buildingBlock.writeBlockData(supportTank.getLocationName(i) + " Equipment", (Vector)vector.get(i));
        }
        buildingBlock.writeBlockData("barrating", supportTank.getBARRating());
        buildingBlock.writeBlockFile(string);
    }
}

