/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.Report;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BATaserHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 1308895663099714573L;

    protected BATaserHandler() {
    }

    public BATaserHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -3;
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            Report report = new Report(3700);
            int n = Compute.d6(2);
            report.add(n);
            report.newlines = 0;
            vector.add(report);
            if (entity instanceof BattleArmor) {
                if (n >= 9) {
                    report = new Report(3706);
                    report.addDesc(entity);
                    HitData hitData = entity.rollHitLocation(0, 0);
                    report.add(entity.getLocationAbbr(hitData));
                    vector.add(report);
                    vector.addAll(this.server.criticalEntity(this.ae, hitData.getLocation(), 0, false, false));
                    bl2 = true;
                }
            } else if (entity instanceof Mech) {
                if (((Mech)entity).isIndustrial()) {
                    if (n >= 11) {
                        entity.baTaserShutdown(3);
                    } else {
                        entity.setTaserInterference(1, 3);
                    }
                } else if (n >= 12) {
                    report = new Report(3705);
                    report.addDesc(entity);
                    report.add(3);
                    vector.add(report);
                    entity.baTaserShutdown(3);
                } else {
                    report = new Report(3710);
                    report.addDesc(entity);
                    report.add(1);
                    report.add(3);
                    vector.add(report);
                    entity.setTaserInterference(1, 3);
                }
            } else if (entity instanceof Protomech || entity instanceof Tank || entity instanceof Aero) {
                if (n >= 11) {
                    report = new Report(3705);
                    report.addDesc(entity);
                    report.add(3);
                    vector.add(report);
                    entity.baTaserShutdown(3);
                } else {
                    report = new Report(3710);
                    report.addDesc(entity);
                    report.add(1);
                    report.add(3);
                    vector.add(report);
                    entity.setTaserInterference(1, 3);
                }
            }
            n = Compute.d6(2);
            report = new Report(3715);
            report.addDesc(this.ae);
            report.add(n);
            report.newlines = 0;
            report.indent(2);
            vector.add(report);
            if (n >= 7) {
                report = new Report(3720);
                vector.add(report);
                this.ae.setTaserFeedback(3);
            } else {
                report = new Report(3725);
                vector.add(report);
                vector.addAll(this.server.criticalEntity(this.ae, this.weapon.getLocation(), 0, false, false));
            }
        }
        return bl2;
    }
}

