/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.dbuml.base.factory.Factory;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBAssociation;
import org.dbuml.base.model.DBDependency;
import org.dbuml.base.model.DBDerive;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.FKey;
import org.dbuml.base.model.PKey;
import org.dbuml.base.model.PKeyInterface;
import org.dbuml.base.model.Registry;
import org.dbuml.base.model.Schema;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;

public class ArgoDBModelFacade
extends DBModelFacade {
    private static final Logger LOG = Logger.getLogger(ArgoDBModelFacade.class);

    public ArgoDBModelFacade() {
        instance = this;
    }

    public static DBModelFacade getInstance() {
        if (instance == null) {
            new ArgoDBModelFacade();
        }
        return instance;
    }

    public boolean representsASchema(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isAPackage(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            status = "Schema".equals(Model.getFacade().getName(o));
        }
        return status;
    }

    public boolean representsADatabase(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isAComponent(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            status = "Database".equals(Model.getFacade().getName(o));
        }
        return status;
    }

    public boolean representsARegistry(Object handle) {
        boolean status = false;
        if (Model.getFacade().isAComponent(handle)) {
            for (Object o : Model.getFacade().getStereotypes(handle)) {
                status = "Registry".equals(Model.getFacade().getName(o));
            }
        }
        return status;
    }

    public boolean representsATable(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isAClass(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            status = Table.getStereotype().equals(Model.getFacade().getName(o));
        }
        return status;
    }

    public boolean representsAView(Object handle) {
        boolean status = false;
        if (Model.getFacade().isAClass(handle)) {
            for (Object o : Model.getFacade().getStereotypes(handle)) {
                status = View.getStereotype().equals(Model.getFacade().getName(o));
            }
        }
        return status;
    }

    public boolean representsAColumn(Object handle) {
        boolean status = false;
        if (Model.getFacade().isAAttribute(handle)) {
            Object owner = Model.getFacade().getOwner(handle);
            status = this.representsADbumlElement(owner);
        }
        return status;
    }

    public boolean representsADbumlElement(Object model) {
        return this.representsADatabase(model) || this.representsASchema(model) || this.representsATable(model) || this.representsAView(model) || this.representsAColumn(model) || this.representsAFKey(model) || this.representsADBDerive(model) || this.representsADBDependency(model);
    }

    public String getDBUMLClassName(Object handle) {
        String status = null;
        if (this.representsADatabase(handle)) {
            status = "Database";
        } else if (this.representsASchema(handle)) {
            status = "Schema";
        } else if (this.representsATable(handle)) {
            status = Table.getStereotype();
        } else if (this.representsAView(handle)) {
            status = View.getStereotype();
        } else if (this.representsAColumn(handle)) {
            status = "Column";
        } else if (this.representsAFKey(handle)) {
            status = "FKey";
        } else if (this.representsADBDerive(handle)) {
            status = "DBDerive";
        } else if (this.representsADBDependency(handle)) {
            status = "DBDependency";
        }
        return status;
    }

    public boolean representsAFKey(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isAAssociation(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            String stereoName = Model.getFacade().getName(o);
            status = "FK".equals(stereoName) || "PFK".equals(stereoName);
        }
        return status;
    }

    public boolean representsADBDerive(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isADependency(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            status = DBDerive.getStereotype().equals(Model.getFacade().getName(o));
        }
        return status;
    }

    public boolean representsADBDependency(Object handle) {
        Iterator its;
        boolean status = false;
        if (Model.getFacade().isADependency(handle) && (its = Model.getFacade().getStereotypes(handle).iterator()).hasNext()) {
            Object o = its.next();
            status = DBDependency.getStereotype().equals(Model.getFacade().getName(o));
        }
        return status;
    }

    public Database findDatabase(String sName) {
        return this.findDatabase(null, sName);
    }

    public Database findDatabase(String parentName, String dbName) {
        Object projectModel = ProjectManager.getManager().getCurrentProject().getModel();
        Object parentModel = parentName != null ? Model.getFacade().lookupIn(projectModel, parentName) : projectModel;
        Object database = Model.getFacade().lookupIn(parentModel, dbName);
        return database != null ? this.getDatabase(database) : null;
    }

    public Database getOwningDatabase(Object element) {
        Database db = null;
        if (element != null) {
            db = this.representsADatabase(element) ? this.getDatabase(element) : this.getOwningDatabase(this.getParent(element));
        }
        return db;
    }

    public Registry getOwningRegistry(Object element) {
        Registry r = null;
        if (element != null) {
            r = this.representsARegistry(element) ? this.getRegistry(element) : this.getOwningRegistry(this.getParent(element));
        }
        return r;
    }

    public Factory getMyFactory(Object element) {
        DBElement dbelement;
        Factory fact = null;
        if (element != null && (dbelement = this.representsARegistry(element) ? DBModelFacade.getInstance().getRegistry(element) : DBModelFacade.getInstance().getOwningDatabase(element)) != null) {
            fact = Factory.getFactory(dbelement.getProperty("Factory"));
        }
        return fact;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element != null) {
            if (this.representsATable(element) || this.representsAView(element)) {
                parent = this.getParentForTableLike(element);
            } else if (this.representsASchema(element)) {
                parent = this.getParentForSchema(element);
            } else if (this.representsAColumn(element)) {
                parent = Model.getFacade().getOwner(element);
            } else if (this.representsADatabase(element)) {
                parent = this.getParentForDatabase(element);
            }
        }
        return parent;
    }

    protected final Object getParentForDatabase(Object element) {
        Iterator iter = Model.getFacade().getClientDependencies(element).iterator();
        Object parent = null;
        while (iter.hasNext()) {
            Iterator iter2;
            Object dep = iter.next();
            Collection suppliers = Model.getFacade().getSuppliers(dep);
            Iterator iter1 = suppliers.iterator();
            int dbcount = 0;
            while (iter1.hasNext()) {
                Object node = iter1.next();
                if (this.representsARegistry(node)) {
                    ++dbcount;
                    continue;
                }
                dbcount = 0;
                break;
            }
            if (dbcount != true || !(iter2 = suppliers.iterator()).hasNext()) continue;
            parent = iter2.next();
        }
        return parent;
    }

    protected final Object getParentForTableLike(Object element) {
        Object ns = Model.getFacade().getNamespace(element);
        Object parent = null;
        if (this.representsASchema(ns)) {
            parent = this.isValidSchema(ns) ? ns : null;
        }
        return parent;
    }

    public Collection getChildren(Object element) {
        Vector vChildren;
        block3: {
            block4: {
                vChildren = new Vector();
                Database db = this.getOwningDatabase(element);
                if (db == null) break block3;
                if (!this.representsADatabase(element)) break block4;
                for (Object dep : Model.getFacade().getSupplierDependencies(element)) {
                    Collection clients = Model.getFacade().getClients(dep);
                    for (Object node : clients) {
                        if (!this.representsASchema(node) || !db.getProperty("Supports_schema").equalsIgnoreCase("true") && !db.isDefaultSchema(Model.getFacade().getName(node))) continue;
                        vChildren.add(node);
                    }
                }
                break block3;
            }
            if (!this.representsASchema(element)) break block3;
            for (Object node : Model.getFacade().getOwnedElements(element)) {
                if (!this.representsATable(node) && !this.representsAView(node)) continue;
                vChildren.add(node);
            }
        }
        return vChildren;
    }

    public Object findChild(String name, Object parentModel) {
        Collection col = this.getChildren(parentModel);
        Iterator it = col.iterator();
        Object child = null;
        boolean found = false;
        while (it.hasNext() && !found) {
            child = it.next();
            if (!name.equals(Model.getFacade().getName(child))) continue;
            found = true;
        }
        return found ? child : null;
    }

    public Collection getChildrenForUpdate(Object element) {
        return this.getChildren(element);
    }

    private Object getParentForSchema(Object element) {
        Object parent = null;
        if (this.representsASchema(element) && !this.representsASchema(Model.getFacade().getNamespace(element))) {
            for (Object dep : Model.getFacade().getClientDependencies(element)) {
                Iterator iter2;
                Collection suppliers = Model.getFacade().getSuppliers(dep);
                Iterator iter1 = suppliers.iterator();
                int dbcount = 0;
                while (iter1.hasNext()) {
                    Object node = iter1.next();
                    if (this.validSchemaDependencySupplier(node)) {
                        ++dbcount;
                        continue;
                    }
                    dbcount = 0;
                    break;
                }
                if (dbcount != true || !(iter2 = suppliers.iterator()).hasNext()) continue;
                Object endObj = iter2.next();
                if (this.representsASchema(endObj)) {
                    parent = null;
                    break;
                }
                parent = endObj;
                break;
            }
        }
        return parent;
    }

    protected boolean isValidSchema(Object model) {
        boolean status = false;
        if (this.isDefaultSchema(model)) {
            status = true;
        } else {
            Database db = this.getOwningDatabase(model);
            if (db != null && db.getProperty("Supports_schema").equalsIgnoreCase("true")) {
                status = true;
            }
        }
        return status;
    }

    public String getDBNamespace(Object element) {
        Schema schema = this.getOwningSchema(element);
        String val = "";
        if (schema != null && !this.isDefaultSchema(schema.getModelElement())) {
            val = schema.getName();
        }
        return val;
    }

    public String getName(Object element) {
        return Model.getFacade().getName(element);
    }

    public Object getType(Object element) {
        return Model.getFacade().getType(element);
    }

    public Object lookupIn(Object handle, String name) {
        return Model.getFacade().lookupIn(handle, name);
    }

    public Schema getOwningSchema(Object element) {
        Schema schema = null;
        if (element != null) {
            schema = this.representsASchema(element) ? (this.isValidSchema(element) ? this.getSchema(element) : null) : this.getOwningSchema(this.getParent(element));
        }
        return schema;
    }

    protected boolean validSchemaDependencySupplier(Object element) {
        return this.representsADatabase(element);
    }

    public Database getDatabase(Object handle) {
        if (!this.representsADatabase(handle)) {
            return null;
        }
        return new Database(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    public Registry getRegistry(Object handle) {
        if (!this.representsARegistry(handle)) {
            return null;
        }
        return new Registry(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    protected void clearTable(Object objTable) {
        Iterator it = Model.getFacade().getAttributes(objTable).iterator();
        while (it.hasNext()) {
            Model.getUmlFactory().delete(it.next());
        }
        for (Object assoEnd : Model.getFacade().getAssociationEnds(objTable)) {
            if (Model.getFacade().isNavigable(assoEnd)) continue;
            Model.getUmlFactory().delete(Model.getFacade().getAssociation(assoEnd));
        }
        it = Model.getFacade().getConstraints(objTable).iterator();
        while (it.hasNext()) {
            Model.getUmlFactory().delete(it.next());
        }
    }

    protected void buildTable(Table table, Object objOwner) {
        LOG.debug((Object)("Building table " + table.getName()));
        this.updateDBElement(table);
        this.addAttributes(table, objOwner);
    }

    public void addTable(Table table, Object objOwner) {
        Object objTable = Model.getCoreFactory().buildClass(table.getName(), objOwner);
        table.setModelElement(objTable);
        this.buildTable(table, objOwner);
    }

    public void addView(View view, Object objOwner) {
        this.addTable(view, objOwner);
        this.addViewBases(view, objOwner);
    }

    public void updateTable(Table table) {
        LOG.debug((Object)("Updating table " + table.getName()));
        this.clearTable(table.getModelElement());
        this.buildTable(table, this.getParent(table.getModelElement()));
    }

    public void updateView(View view) {
        this.updateTable(view);
        this.addViewBases(view, this.getParent(view.getModelElement()));
    }

    protected void addViewBases(View view, Object objOwner) {
        String[] baseNames = view.getBaseTablesFromQuery();
        for (int i = 0; i < baseNames.length; ++i) {
            Object viewModel = view.getModelElement();
            Object baseModel = Model.getFacade().lookupIn(objOwner, baseNames[i]);
            if (baseModel == null) {
                String tSchema = null;
                String tName = baseNames[i];
                int indexOfPeriod = tName.indexOf(46);
                if (indexOfPeriod > 0) {
                    tSchema = tName.substring(0, indexOfPeriod);
                    tName = tName.substring(indexOfPeriod + 1);
                }
                Table baseTable = new Table(tName);
                Object baseTableOwner = objOwner;
                if (tSchema != null && (baseTableOwner = this.lookupIn(this.getParent(objOwner), tSchema)) == null) {
                    Schema schema = new Schema(tSchema);
                    this.addSchema(new Schema(tSchema), this.getOwningDatabase(objOwner));
                    baseTableOwner = schema.getModelElement();
                }
                this.addTable(baseTable, baseTableOwner);
                baseModel = baseTable.getModelElement();
            }
            Object dep = Model.getCoreFactory().buildDependency(viewModel, baseModel);
            Model.getCoreHelper().setNamespace(dep, objOwner);
            DBDerive derive = new DBDerive(dep);
            derive.setName(Model.getFacade().getName(viewModel) + "->" + Model.getFacade().getName(baseModel));
            this.updateDBDerive(derive);
        }
    }

    protected void addAttributes(Table table, Object objOwner) {
        LOG.debug((Object)("Adding attributes to model of table " + table.getName()));
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            this.processColumn(columns[i], table.getModelElement());
        }
        this.addConstraintsToModel(table);
    }

    protected void addConstraintsToModel(Table table) {
        Map indexMap = table.getIndexMap();
        Iterator it = indexMap.keySet().iterator();
        Set setOfColumns = null;
        while (it.hasNext()) {
            String indexName = (String)it.next();
            setOfColumns = (Set)indexMap.get(indexName);
            HashSet<String> colNames = new HashSet<String>();
            Iterator colIter = setOfColumns.iterator();
            Column column = (Column)colIter.next();
            colNames.add(column.getName());
            while (colIter.hasNext()) {
                colNames.add(((Column)colIter.next()).getName());
            }
            this.addConstraintUnique(table.getModelElement(), colNames, indexName);
        }
    }

    public void addConstraintUnique(Object tableModel, Set setOfColumnNames, String indexName) {
        Object mc = this.buildConstraintUnique(Model.getFacade().getName(tableModel), setOfColumnNames, indexName);
        this.addConstraintToModel(mc, tableModel);
    }

    protected void processColumn(Column column, Object tableModel) {
        LOG.debug((Object)("Processing column " + column.getName()));
        this.addColumn(column, tableModel);
        if (column.isForeignKey()) {
            this.addForeignKeyRelation(tableModel, column);
        }
        if (!(column.isPrimaryKey() || column.isForeignKey() || column.allowsNulls())) {
            this.addConstraintNotNull(column.getName(), tableModel);
        }
    }

    public void addConstraintNotNull(String columnName, Object tableModel) {
        Object mc = this.buildConstraintNotnull(Model.getFacade().getName(tableModel), columnName);
        this.addConstraintToModel(mc, tableModel);
    }

    private void addConstraintToModel(Object mc, Object model) {
        if (mc != null) {
            Model.getCoreHelper().addConstraint(model, mc);
            Model.getCoreHelper().addOwnedElement(Model.getFacade().getNamespace(model), mc);
        }
    }

    private Object buildConstraintNotnull(String context, String attrName) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("context ");
        buf.append(context);
        buf.append(" inv ");
        String constraintName = attrName.toLowerCase() + "_notnull";
        buf.append(constraintName);
        buf.append(": self.");
        buf.append(attrName);
        buf.append("->notEmpty");
        return this.createOCLConstraint(constraintName, buf.toString());
    }

    private Object buildConstraintUnique(String context, Set setOfColNames, String indexName) {
        if (setOfColNames.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer("context ");
        buf.append(context);
        buf.append(" inv ");
        Iterator it = setOfColNames.iterator();
        String colName = (String)it.next();
        String constraintName = indexName.toLowerCase();
        buf.append(constraintName);
        buf.append(": ");
        buf.append(context);
        if (setOfColNames.size() == 1) {
            buf.append(".allInstances->isUnique(");
            buf.append(colName);
            buf.append(')');
        } else if (setOfColNames.size() > 1) {
            buf.append(".allInstances->forAll (x,y | x<>y implies (x.");
            buf.append(colName);
            buf.append("<>y.");
            buf.append(colName);
            while (it.hasNext()) {
                colName = (String)it.next();
                buf.append(" and x.");
                buf.append(colName);
                buf.append("<>y.");
                buf.append(colName);
            }
            buf.append(" ))");
        }
        return this.createOCLConstraint(constraintName, buf.toString());
    }

    private Object createOCLConstraint(String constraintName, String expr) {
        Object bexpr = Model.getDataTypesFactory().createBooleanExpression("OCL", expr);
        Object mc = Model.getCoreFactory().buildConstraint(constraintName, bexpr);
        return mc;
    }

    public void addColumn(Column column, Object tableModel, boolean forView) {
        Project p = ProjectManager.getManager().getCurrentProject();
        Object mType = null;
        String typeName = column.getTypeName();
        if (typeName != null) {
            mType = forView ? p.findType(typeName, true) : p.findType(typeName.toUpperCase(), false);
        }
        if (mType == null && column.getTypeNameJdbc() != null) {
            mType = p.findType(column.getTypeNameJdbc().toUpperCase(), false);
        }
        Object model = ProjectManager.getManager().getCurrentProject().getModel();
        Object mAttr = Model.getCoreFactory().buildAttribute(tableModel, model, mType);
        this.setVisibilityDefault(mAttr);
        column.setModelElement(mAttr);
        this.updateDBElement(column);
    }

    protected void setVisibilityDefault(Object model) {
        Model.getCoreHelper().setVisibility(model, Model.getVisibilityKind().getPackage());
    }

    public void addColumn(Column column, Object tableModel) {
        this.addColumn(column, tableModel, false);
    }

    private void addForeignKeyRelation(Object fromTable, Column col) {
        String assoName;
        if (!col.isRelated()) {
            return;
        }
        Object objOwner = this.getParent(fromTable);
        if (objOwner == null) {
            return;
        }
        Object toTable = Model.getFacade().lookupIn(objOwner, col.getRelatedTableName());
        if (toTable == null) {
            LOG.debug((Object)("****Unable to find the model for table " + col.getRelatedTableName() + ". So, create it!!!!!"));
            Table t = new Table(col.getRelatedTableName());
            this.addTable(t, objOwner);
            toTable = t.getModelElement();
        }
        if (!this.hasAssociation(fromTable, assoName = col.getName())) {
            Object asso = this.buildAssociation(fromTable, toTable, assoName);
            if (col.isForeignKey()) {
                FKey fkey = col.getKey().getForeignKey();
                fkey.setModelElement(asso, fromTable, toTable);
                this.updateDBAssociation(fkey);
            }
        }
    }

    public void updateDBDerive(DBDerive derive) {
        Object schema;
        Object source = derive.getSourceModel();
        Object target = derive.getTargetModel();
        if (source != null && target != null && (schema = this.getParent(source)) == null && (schema = this.getParent(target)) != null) {
            Model.getCoreHelper().setNamespace(source, schema);
        }
        this.updateDBElement(derive);
    }

    public void updateDBDependency(DBDependency depend) {
        Object source = depend.getSourceModel();
        Object target = depend.getTargetModel();
        if (source != null && target != null) {
            depend.setName(this.getName(source) + "->" + this.getName(target));
            if (this.representsASchema(source) && this.representsADatabase(target)) {
                Model.getCoreHelper().setNamespace(source, target);
                Model.getCoreHelper().setNamespace(depend.getModelElement(), source);
            }
        }
        this.updateDBElement(depend, false);
    }

    public void updateDBAssociation(DBAssociation dbAsso) {
        if (dbAsso != null) {
            Object targetModel;
            Object asso = dbAsso.getModelElement();
            if (asso == null) {
                return;
            }
            Object sourceModel = dbAsso.getSourceModel();
            if (sourceModel != null) {
                String sourceEndStereoStr;
                Object fromEnd = Model.getFacade().getAssociationEnd(sourceModel, asso);
                String sourceEndName = dbAsso.getSourceEndName();
                if (sourceEndName != null) {
                    Model.getCoreHelper().setName(fromEnd, sourceEndName);
                }
                if ((sourceEndStereoStr = dbAsso.getSourceEndStereoString()) != null) {
                    this.addStereotype(sourceEndStereoStr, fromEnd);
                }
            }
            if ((targetModel = dbAsso.getTargetModel()) != null) {
                String sourceEndStereoStr;
                Object fromEnd = Model.getFacade().getAssociationEnd(sourceModel, asso);
                String sourceEndName = dbAsso.getSourceEndName();
                if (sourceEndName != null) {
                    Model.getCoreHelper().setName(fromEnd, sourceEndName);
                }
                if ((sourceEndStereoStr = dbAsso.getSourceEndStereoString()) != null) {
                    this.addStereotype(sourceEndStereoStr, fromEnd);
                }
                if (dbAsso.isSourceMultiplicityAtMostOne()) {
                    Model.getCoreHelper().setMultiplicity(fromEnd, (Object)"0_1");
                } else if (dbAsso.isSourceMultiplicityAtLeastOne()) {
                    Model.getCoreHelper().setMultiplicity(fromEnd, (Object)"1_N");
                } else if (dbAsso.isSourceMultiplicityZeroOrMore()) {
                    Model.getCoreHelper().setMultiplicity(fromEnd, (Object)"0_N");
                }
                if (dbAsso.isSourceOrdered()) {
                    Model.getCoreHelper().setOrdering(fromEnd, Model.getOrderingKind().getOrdered());
                }
            }
            this.updateDBElement(dbAsso);
        }
    }

    protected Object buildAssociation(Object from, Object to, String name) {
        try {
            Object asso = Model.getUmlFactory().buildConnection(Model.getMetaTypes().getAssociation(), from, null, to, null, (Object)Boolean.TRUE, null);
            Model.getCoreHelper().setName(asso, name);
            return asso;
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage());
            return null;
        }
    }

    protected boolean hasAssociation(Object from, String assoName) {
        for (Object assoEnd : Model.getFacade().getAssociationEnds(from)) {
            Object asso = Model.getFacade().getAssociation(assoEnd);
            if (!assoName.equalsIgnoreCase(Model.getFacade().getName(asso))) continue;
            return true;
        }
        return false;
    }

    protected Object getAssociationEnd(Object from, String assoName) {
        for (Object assoEnd : Model.getFacade().getAssociationEnds(from)) {
            Object asso = Model.getFacade().getAssociation(assoEnd);
            if (!assoName.equalsIgnoreCase(Model.getFacade().getName(asso))) continue;
            return assoEnd;
        }
        return null;
    }

    public void addSchema(Schema schema, Object owner) {
        Object objSchema = Model.getModelManagementFactory().buildPackage(schema.getName(), schema.getName());
        Model.getCoreHelper().setNamespace(objSchema, owner);
        schema.setModelElement(objSchema);
        this.updateDBElement(schema);
        Object dep = Model.getCoreFactory().buildDependency(objSchema, owner);
        DBDependency dbdep = new DBDependency(dep, objSchema, owner);
        this.updateDBDependency(dbdep);
    }

    public void addDatabase(Database database, Object owner) {
        Object component = Model.getCoreFactory().createComponent();
        Model.getCoreHelper().setName(component, database.getName());
        Model.getCoreHelper().setNamespace(component, owner);
        database.setModelElement(component);
        this.updateDatabase(database);
        if (owner != null) {
            Object dep = Model.getCoreFactory().buildDependency(component, owner);
            String depName = Model.getFacade().getName(component) + "->" + Model.getFacade().getName(owner);
            Model.getCoreHelper().setName(dep, depName);
            Model.getCoreHelper().setNamespace(dep, owner);
        }
    }

    protected void updateDBElement(DBElement dbelem) {
        this.updateDBElement(dbelem, true);
    }

    private void updateDBElement(DBElement dbelem, boolean addStereotypes) {
        Object objElement = dbelem.getModelElement();
        dbelem.setOwningDatabase(this.getOwningDatabase(objElement));
        String name = dbelem.getName();
        if (name != null) {
            Model.getCoreHelper().setName(objElement, name);
        }
        this.setTags(dbelem.getProperties(), objElement);
        if (addStereotypes) {
            Vector vStereos = new Vector(Model.getFacade().getStereotypes(objElement));
            Enumeration e = vStereos.elements();
            while (e.hasMoreElements()) {
                Object objStereo = e.nextElement();
                if (objStereo == null || Model.getFacade().getName(objStereo) != dbelem.getStereostring()) continue;
                return;
            }
            Object model = ProjectManager.getManager().getCurrentProject().getModel();
            vStereos = new Vector(Model.getExtensionMechanismsHelper().getStereotypes(model));
            Enumeration e2 = vStereos.elements();
            while (e2.hasMoreElements()) {
                Object objStereo = e2.nextElement();
                if (objStereo == null || Model.getFacade().getName(objStereo) != dbelem.getStereostring()) continue;
                Model.getCoreHelper().addStereotype(objElement, objStereo);
                return;
            }
            Object objS = this.addStereotype(dbelem.getStereostring(), objElement);
            if (objS != null) {
                Model.getCoreHelper().addStereotype(objElement, objS);
            }
        }
    }

    public void updateSchema(Schema schema) {
        this.updateDBElement(schema);
    }

    public void updateRegistry(Registry registry) {
        this.updateDBElement(registry);
    }

    public void updateDatabase(Database database) {
        this.updateDBElement(database);
    }

    public void updateFKey(FKey fkey) {
        this.updateDBAssociation(fkey);
    }

    public void updateColumn(Column column) {
        Project p = ProjectManager.getManager().getCurrentProject();
        Object mType = null;
        String typeName = column.getTypeName();
        if (typeName != null) {
            mType = p.findType(typeName.toUpperCase(), false);
        }
        if (mType == null && column.getTypeNameJdbc() != null) {
            mType = p.findType(column.getTypeNameJdbc().toUpperCase(), false);
        }
        Model.getCoreHelper().setType(column.getModelElement(), mType);
        this.setVisibilityDefault(column.getModelElement());
        this.updateDBElement(column);
    }

    public Schema getSchema(Object handle) {
        if (!this.representsASchema(handle)) {
            return null;
        }
        return new Schema(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    public Table getTable(Object handle) {
        if (!this.representsATable(handle)) {
            return null;
        }
        Table table = this.newTable(Model.getFacade().getName(handle), handle, this.getTags(handle));
        this.getTableColumnsFromModel(table, true);
        return table;
    }

    public Table getTableNoAssoc(Object handle) {
        if (!this.representsATable(handle)) {
            return null;
        }
        Table table = this.newTable(Model.getFacade().getName(handle), handle, this.getTags(handle));
        this.getTableColumnsFromModel(table, false);
        return table;
    }

    protected void getTableColumnsFromModel(Table table, boolean bAssoc) {
        List attrs = Model.getFacade().getAttributes(table.getModelElement());
        Iterator it = attrs.iterator();
        ArrayList<Column> alColumns = new ArrayList<Column>();
        while (it.hasNext()) {
            alColumns.add(this.getColumnPartially(it.next(), bAssoc));
        }
        table.setColumns(alColumns.toArray(new Column[0]));
        this.addConstraintsToAttributes(table);
    }

    public View getView(Object handle) {
        if (!this.representsAView(handle)) {
            return null;
        }
        View view = this.newView(Model.getFacade().getName(handle), handle, this.getTags(handle));
        this.getTableColumnsFromModel(view, true);
        return view;
    }

    private void addConstraintsToAttributes(Table table) {
        Iterator it = Model.getFacade().getConstraints(table.getModelElement()).iterator();
        while (it.hasNext()) {
            String colName;
            Column col;
            String stmt = Model.getFacade().getBody(Model.getFacade().getBody(it.next())).toString();
            int colon = stmt.indexOf(58);
            if (colon <= 0) continue;
            String right = stmt.substring(colon + 1).trim();
            if (right.indexOf("isUnique") > 0) {
                if (!(right = right.substring(right.indexOf("isUnique") + 8).trim()).startsWith("(") || (col = table.getColumn(colName = right.substring(1, right.length() - 1).trim())) == null) continue;
                col.isUnique(true);
                if (col.getIndexNames().length > 0) {
                    table.recordIndex(col);
                    continue;
                }
                LOG.error((Object)("INDEX_NAME tag is missing for attribute " + colName + " on table " + table.getName()));
                continue;
            }
            if (right.indexOf("implies") > 0) {
                if ((right = right.substring(right.indexOf("implies") + 7).trim()).startsWith("(") && (right = right.substring(1)).endsWith(")")) {
                    right = right.substring(0, right.length() - 1).trim();
                }
                if (right.endsWith(")")) {
                    right = right.substring(0, right.length() - 1).trim();
                }
                String[] stmts = right.split("and");
                for (int i = 0; i < stmts.length; ++i) {
                    String colName2;
                    Column col2;
                    if (stmts[i].indexOf(46) <= 0 || stmts[i].indexOf("<>") <= 0 || (col2 = table.getColumn(colName2 = stmts[i].substring(stmts[i].indexOf(46) + 1, stmts[i].indexOf("<>")).trim())) == null) continue;
                    if (stmts.length > 1) {
                        col2.isPartOfUniqueConstraint(true);
                    } else {
                        col2.isUnique(true);
                    }
                    if (col2.getIndexNames().length > 0) {
                        table.recordIndex(col2);
                        continue;
                    }
                    LOG.error((Object)("INDEX_NAME tag is missing for attribute " + colName2 + " on table " + table.getName()));
                }
                continue;
            }
            if (right.matches("self.*->notEmpty")) {
                colName = right.substring(right.indexOf(46) + 1, right.indexOf("->"));
                col = table.getColumn(colName);
                if (col == null) continue;
                col.setAllowsNulls(false);
                continue;
            }
            LOG.error((Object)("We no not understand the OCL statement: " + stmt));
        }
        table.markUniqueColumns();
    }

    protected Table newTable(String sName, Object handle, Properties properties) {
        return new Table(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    protected View newView(String sName, Object handle, Properties properties) {
        return new View(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    protected Column newColumn(String sName, Object handle, Properties properties) {
        return new Column(Model.getFacade().getName(handle), handle, this.getTags(handle));
    }

    public Column getColumnPartially(Object handle, boolean bAssoc) {
        if (!this.representsAColumn(handle)) {
            return null;
        }
        Column col = this.newColumn(Model.getFacade().getName(handle), handle, this.getTags(handle));
        Object type = Model.getFacade().getType(handle);
        col.setTypeName(Model.getFacade().getName(type));
        Iterator its = Model.getFacade().getStereotypes(handle).iterator();
        if (its.hasNext()) {
            Object stereo = its.next();
            String name = Model.getFacade().getName(stereo);
            if (name.equals("PK")) {
                PKey key = this.getPKey(handle);
                if (key != null) {
                    col.setKey(key);
                }
            } else if (name.equals("FK") && bAssoc) {
                FKey key = this.getFKey(handle);
                if (key != null) {
                    col.setKey(key);
                }
            } else if (name.equals("PFK") && bAssoc) {
                FKey fkey;
                PKey pkey = this.getPKey(handle);
                if (pkey != null) {
                    col.setKey(pkey);
                }
                if ((fkey = this.getFKey(handle)) != null) {
                    col.setKey(fkey);
                }
            }
        }
        return col;
    }

    private PKey getPKey(Object attrModel) {
        String tableName = null;
        Object schema = null;
        String schemaName = null;
        PKey pkey = null;
        Object table = this.getParent(attrModel);
        if (table != null) {
            tableName = Model.getFacade().getName(table);
            schema = this.getParent(table);
            if (schema != null) {
                schemaName = Model.getFacade().getName(schema);
            }
            Properties prop = this.getTags(attrModel);
            short seq = 1;
            try {
                seq = Short.parseShort(prop.getProperty("KEY_SEQ"));
            }
            catch (NumberFormatException e) {
                LOG.info((Object)e.getMessage());
            }
            pkey = new PKey(schemaName, tableName, Model.getFacade().getName(attrModel), seq, prop.getProperty("PK_NAME"));
        }
        return pkey;
    }

    private FKey getFKey(Object attrModel) {
        String tableName = null;
        Object schema = null;
        String schemaName = null;
        FKey key = null;
        Object table = this.getParent(attrModel);
        if (table != null) {
            tableName = Model.getFacade().getName(table);
            schema = this.getParent(table);
            if (schema != null) {
                schemaName = Model.getFacade().getName(schema);
            }
            String attrName = Model.getFacade().getName(attrModel);
            String relatedSchemaName = null;
            String relatedTableName = null;
            String relatedColumnName = null;
            String relatedKeyName = null;
            Object assoEnd = this.getAssociationEnd(table, attrName);
            Object asso = null;
            short seq = 1;
            String keyName = null;
            String updateRule = null;
            String deleteRule = null;
            if (assoEnd != null) {
                relatedColumnName = Model.getFacade().getName(assoEnd);
                asso = Model.getFacade().getAssociation(assoEnd);
                Properties prop = this.getTags(asso);
                keyName = prop.getProperty("FK_NAME");
                try {
                    seq = Short.parseShort(prop.getProperty("KEY_SEQ"));
                }
                catch (NumberFormatException e) {
                    LOG.info((Object)e.getMessage());
                }
                updateRule = prop.getProperty("UPDATE_RULE");
                deleteRule = prop.getProperty("DELETE_RULE");
            }
            key = new FKey(schemaName, tableName, attrName, seq, keyName);
            key.setUpdateRule(updateRule);
            key.setDeleteRule(deleteRule);
            Table relatedTable = this.getAssociatedTable(table, attrName);
            if (relatedTable != null) {
                relatedTableName = relatedTable.getName();
                Object relTableModel = relatedTable.getModelElement();
                Object relSchemaModel = this.getParent(relTableModel);
                if (relSchemaModel != null) {
                    relatedSchemaName = Model.getFacade().getName(relSchemaModel);
                }
                if (assoEnd != null) {
                    PKeyInterface pkey;
                    Column col = relatedTable.getColumn(Model.getFacade().getName(assoEnd));
                    if (col != null && col.isPrimaryKey() && (pkey = col.getKey()) != null) {
                        relatedKeyName = pkey.getKeyName();
                    }
                    key.setNativeData(relatedSchemaName, relatedTableName, relatedColumnName, relatedKeyName);
                }
            }
        }
        return key;
    }

    private Table getAssociatedTable(Object tableModel, String assoName) {
        Collection col = Model.getFacade().getAssociatedClasses(tableModel);
        for (Object otherTable : col) {
            Object assoEnd = this.getAssociationEnd(otherTable, assoName);
            if (assoEnd == null) continue;
            return this.getTableNoAssoc(otherTable);
        }
        return null;
    }

    public DBElement getDBElement(Object handle) {
        DBElement dbe = this.getTable(handle);
        if (dbe != null) {
            return dbe;
        }
        dbe = this.getColumnPartially(handle, true);
        if (dbe != null) {
            return dbe;
        }
        dbe = this.getView(handle);
        if (dbe != null) {
            return dbe;
        }
        dbe = this.getSchema(handle);
        if (dbe != null) {
            return dbe;
        }
        dbe = this.getRegistry(handle);
        if (dbe != null) {
            return dbe;
        }
        dbe = this.getDatabase(handle);
        return dbe;
    }

    private Object addStereotype(String sStereo, Object obj) {
        Object newStereo = null;
        if (sStereo != null && sStereo != "") {
            Object myNS = Model.getFacade().isANamespace(obj) ? obj : ProjectManager.getManager().getCurrentProject().getModel();
            newStereo = Model.getExtensionMechanismsFactory().buildStereotype(obj, (Object)sStereo, myNS);
        }
        return newStereo;
    }

    protected void setTags(Map properties, Object obj) {
        Vector<Object> collTags = new Vector<Object>();
        for (String sKey : properties.keySet()) {
            Object objTag = Model.getExtensionMechanismsFactory().buildTaggedValue(sKey, (String)properties.get(sKey));
            collTags.add(objTag);
        }
        Model.getCoreHelper().setTaggedValues(obj, collTags);
    }

    protected Properties getTags(Object obj) {
        Properties properties = new Properties();
        Iterator i = Model.getFacade().getTaggedValues(obj);
        while (i.hasNext()) {
            Object oTag = i.next();
            properties.setProperty(Model.getFacade().getTagOfTag(oTag), (String)Model.getFacade().getValue(oTag));
        }
        return properties;
    }

    public String getModelElementName(Object handle) {
        String sValue = Model.getFacade().getName(handle);
        return sValue == null ? "" : sValue;
    }

    public void addTypes(String[] sTypes, String pkgName) {
        Object pkg = this.getPackage(pkgName);
        Project p = ProjectManager.getManager().getCurrentProject();
        for (int i = 0; i < sTypes.length; ++i) {
            Object mType = p.findType(sTypes[i], false);
            if (mType != null) continue;
            Model.getCoreFactory().buildDataType(sTypes[i], pkg);
        }
    }

    public boolean checkTypes(String[] sTypes) {
        Project p = ProjectManager.getManager().getCurrentProject();
        for (int i = 0; i < sTypes.length; ++i) {
            Object mType = p.findType(sTypes[i], false);
            if (mType != null) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultSchema(Object handle) {
        if (this.representsASchema(handle)) {
            Database database = this.getOwningDatabase(handle);
            return database != null && database.isDefaultSchema(Model.getFacade().getName(handle));
        }
        return false;
    }

    public Collection getViewBaseModels(Object viewModel) {
        Vector bases = new Vector();
        if (this.representsAView(viewModel)) {
            for (Object dep : Model.getFacade().getClientDependencies(viewModel)) {
                if (!this.representsADBDerive(dep)) continue;
                Collection suppliers = Model.getFacade().getSuppliers(dep);
                Iterator iter1 = suppliers.iterator();
                while (iter1.hasNext()) {
                    bases.add(iter1.next());
                }
            }
        }
        return bases;
    }

    private Object getPackage(String name) {
        Object mPackage = this.searchPackageInModel(name);
        if (mPackage == null) {
            mPackage = Model.getModelManagementFactory().buildPackage(this.getRelativePackageName(name), name);
            Model.getCoreHelper().setNamespace(mPackage, ProjectManager.getManager().getCurrentProject().getModel());
            if ("".equals(this.getPackageName(name))) {
                Model.getCoreHelper().addOwnedElement(ProjectManager.getManager().getCurrentProject().getModel(), mPackage);
            } else {
                Model.getCoreHelper().addOwnedElement(this.getPackage(this.getPackageName(name)), mPackage);
            }
        }
        return mPackage;
    }

    private Object searchPackageInModel(String name) {
        if ("".equals(this.getPackageName(name))) {
            return Model.getFacade().lookupIn(ProjectManager.getManager().getCurrentProject().getModel(), name);
        }
        Object owner = this.searchPackageInModel(this.getPackageName(name));
        return owner == null ? null : Model.getFacade().lookupIn(owner, this.getRelativePackageName(name));
    }

    private String getRelativePackageName(String packageName) {
        int lastDot = packageName.lastIndexOf(46);
        if (lastDot == -1) {
            return packageName;
        }
        return packageName.substring(lastDot + 1);
    }

    private String getPackageName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(0, lastDot);
    }
}

