/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;
import oracle.jdbc.ttc7.TTIrid;

public class TTIoer
extends TTIMsg {
    private final int MAXERRBUF = 512;
    private long curRowNumber;
    private int retCode;
    private int arrayElemWError;
    private int arrayElemErrno;
    private int currCursorID;
    private short errorPosition;
    private short sqlType;
    private byte oerFatal;
    private short flags;
    private short userCursorOpt;
    private short upiParam;
    private short warningFlag;
    private TTIrid rid;
    private int osError;
    private short stmtNumber;
    private short callNumber;
    private int pad1;
    private long successIters;
    private int warnLength = 0;
    private int warnFlag = 0;
    private int[] errorLength = new int[1];
    private byte[] errorMsg;
    public static final int ORA1403 = 1403;

    public TTIoer(MAREngine mAREngine) {
        this.setMarshalingEngine(mAREngine);
        this.rid = new TTIrid(mAREngine);
    }

    public void init() {
        this.retCode = 0;
        this.errorMsg = null;
    }

    public void unmarshal() throws IOException, SQLException {
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB2();
        this.userCursorOpt = this.meg.unmarshalSB2();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rid.unmarshal();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        if (this.retCode != 0) {
            this.errorMsg = this.meg.unmarshalCLRforREFS();
            this.errorLength[0] = this.errorMsg.length;
        }
    }

    public void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0 && this.warnLength > 0) {
            short s = this.meg.unmarshalUB1();
            this.errorMsg = new byte[this.warnLength];
            if (s == this.warnLength) {
                this.meg.getNBytes(this.errorMsg, 0, this.warnLength);
            } else {
                byte[] byArray = new byte[this.warnLength];
                int n = this.warnLength - 1;
                this.meg.getNBytes(byArray, 0, n);
                this.errorMsg[0] = (byte)s;
                System.arraycopy(byArray, 0, this.errorMsg, 1, n);
            }
            this.errorLength[0] = this.warnLength;
        }
    }

    public void print(int n, int n2, int n3) throws SQLException {
        System.out.println("**** Retcode is " + this.retCode);
        if (this.retCode != 0) {
            System.out.println("**** Error Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0]));
        } else if (this.warnFlag != 0) {
            OracleLog.print(this, n, n2, n3, "Warning Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.warnLength));
        }
    }

    public void processError() throws SQLException {
        int n;
        if (this.retCode != 0) {
            DBError.throwSqlException(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0]), DBError.ErrorToSQLState(this.retCode), this.retCode);
        }
        if ((this.warningFlag & 1) == 1 && (((n = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (n & 4) == 4)) {
            throw DBError.newSqlException(110);
        }
    }

    public void processWarning() throws SQLException {
        if (this.retCode != 0) {
            throw DBError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0]), DBError.ErrorToSQLState(this.retCode), this.retCode);
        }
    }

    public int getCurRowNumber() throws SQLException {
        return (int)this.curRowNumber;
    }

    public int getRetCode() {
        return this.retCode;
    }
}

