/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain.scan;

import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import com.jgoodies.jdiskreport.domain.ScanResult;
import com.jgoodies.jdiskreport.domain.scan.Scanner;
import java.io.File;

public class ConsoleScanLog
implements Scanner.ScanLog {
    private static final int LOG_INTERVAL_MILLIS = 1000;
    private long lastLogTime = System.currentTimeMillis();

    @Override
    public void logConfiguration(ScanConfiguration configuration) {
        System.out.println();
        System.out.println(configuration);
    }

    @Override
    public void logWarning(String message) {
        System.err.println(message);
    }

    @Override
    public void logSummary(ScanResult result) {
        System.out.println();
        System.out.println(result);
    }

    @Override
    public void logDirectory(File directory, int level) {
        if (level < 2) {
            System.out.println();
            System.out.print("Scanning " + directory.getPath());
        } else {
            this.logProgress();
        }
    }

    private void logProgress() {
        long now = System.currentTimeMillis();
        if (now - this.lastLogTime < 1000L) {
            return;
        }
        System.out.print('.');
        this.lastLogTime = now;
    }
}

