/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "checkType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "CONCURRENT_PACKAGE", "Lorg/jetbrains/kotlin/name/FqName;", "CONCURRENT_NAME_SET", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeSpecificAtomicChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeSpecificAtomicChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n23#2:70\n1869#3,2:71\n1869#3,2:74\n1634#3,3:76\n1#4:73\n*S KotlinDebug\n*F\n+ 1 FirNativeSpecificAtomicChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker\n*L\n30#1:70\n34#1:71,2\n42#1:74,2\n67#1:76,3\n*E\n"})
public final class FirNativeSpecificAtomicChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeSpecificAtomicChecker INSTANCE;
    @NotNull
    private static final FqName CONCURRENT_PACKAGE;
    @NotNull
    private static final Set<Name> CONCURRENT_NAME_SET;

    private FirNativeSpecificAtomicChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility = false;
        if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI() || declaration instanceof FirValueParameter || declaration instanceof FirAnonymousFunction) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = declaration.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            INSTANCE.checkType(context2, reporter, (FirTypeRef)it);
        }
        Iterable $this$forEach$iv = declaration.getContextParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl = false;
            INSTANCE.checkType(context2, reporter, it.getReturnTypeRef());
        }
        FirTypeRef it = $i$f$forEach = declaration.getReturnTypeRef();
        boolean bl = false;
        KtSourceElement ktSourceElement = it.getSource();
        FirTypeRef firTypeRef = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind ? $i$f$forEach : null;
        if (firTypeRef != null) {
            it = firTypeRef;
            boolean bl2 = false;
            INSTANCE.checkType(context2, reporter, it);
        }
        if (!(declaration instanceof FirFunction) || declaration instanceof FirPropertyAccessor) {
            return;
        }
        $this$forEach$iv = ((FirFunction)declaration).getValueParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it2 = (FirValueParameter)element$iv;
            boolean bl3 = false;
            INSTANCE.checkType(context2, reporter, it2.getReturnTypeRef());
        }
    }

    private final void checkType(CheckerContext context2, DiagnosticReporter reporter, FirTypeRef typeRef) {
        ClassId classId = FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(typeRef), context2.getSession());
        if (classId == null) {
            return;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), CONCURRENT_PACKAGE)) {
            return;
        }
        if (classId2.getParentClassId() != null) {
            return;
        }
        Name name2 = classId2.getShortClassName();
        if (!CONCURRENT_NAME_SET.contains(name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirNativeErrors.INSTANCE.getNATIVE_SPECIFIC_ATOMIC(), (Object)name2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new FirNativeSpecificAtomicChecker();
        CONCURRENT_PACKAGE = new FqName("kotlin.concurrent");
        Object object = new String[]{"AtomicIntArray", "AtomicLongArray", "AtomicArray", "AtomicInt", "AtomicLong", "AtomicReference"};
        object = CollectionsKt.listOf(object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier((String)it));
        }
        CONCURRENT_NAME_SET = CollectionsKt.toSet((Iterable)var1_1);
    }
}

