//**************************************************************************************************
//                                         PrcPdfVwr.cpp                                           *
//                                        ---------------                                          *
// Started     : 2020-08-03                                                                        *
// Last Update : 2020-09-30                                                                        *
// Copyright   : (C) 2020 MSWaters                                                                 *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#include "PrcPdfVwr.hpp"

//**************************************************************************************************
// Allocate storage for static data members.

wxArrayString  PrcPdfVwr::m_osaPdfVwrBinLst;

//**************************************************************************************************
// Constructor.

PrcPdfVwr::PrcPdfVwr( void ) : PrcBase( wxPROCESS_REDIRECT )
{
}

//**************************************************************************************************
// Destructor.

PrcPdfVwr::~PrcPdfVwr( )
{
}

//**************************************************************************************************
// Load class list attribute m_osaPdfVwrBinLst with possible PDF viewer application binary names.

void  PrcPdfVwr::InitPdfVwrBinLst( void )
{
  SysScan  oSysScan;
  int      i1;

  // Load the binary list with all possible PDF viewer application binaries
#ifndef __WXMSW__
  m_osaPdfVwrBinLst.Add( "acroread" );
  m_osaPdfVwrBinLst.Add( "atril" );
  m_osaPdfVwrBinLst.Add( "epdf" );
  m_osaPdfVwrBinLst.Add( "evince" );
  m_osaPdfVwrBinLst.Add( "gv" );
  m_osaPdfVwrBinLst.Add( "kpdf" );
  m_osaPdfVwrBinLst.Add( "mupdf" );
  m_osaPdfVwrBinLst.Add( "okular" );
  m_osaPdfVwrBinLst.Add( "qpdfview" );
  m_osaPdfVwrBinLst.Add( "xpdf" );
  m_osaPdfVwrBinLst.Add( "zathura" );
#else
  m_osaPdfVwrBinLst.Add( "acroread.exe" );
  m_osaPdfVwrBinLst.Add( "atril.exe" );
  m_osaPdfVwrBinLst.Add( "epdf.exe" );
  m_osaPdfVwrBinLst.Add( "evince.exe" );
  m_osaPdfVwrBinLst.Add( "gv.exe" );
  m_osaPdfVwrBinLst.Add( "kpdf.exe" );
  m_osaPdfVwrBinLst.Add( "mupdf.exe" );
  m_osaPdfVwrBinLst.Add( "okular.exe" );
  m_osaPdfVwrBinLst.Add( "qpdfview.exe" );
  m_osaPdfVwrBinLst.Add( "xpdf.exe" );
  m_osaPdfVwrBinLst.Add( "zathura.exe" );
#endif // __WXMSW__

  // Delete from the binary list any that aren't currently installed on the system
  // (need to go thro. the list backwards otherwise item positions change when an item is deleted)
  for( i1=m_osaPdfVwrBinLst.GetCount( )-1; i1>=0; i1-- )
    if( ! oSysScan.bIsInstalled( m_osaPdfVwrBinLst.Item( (size_t) i1 ) ) )
      m_osaPdfVwrBinLst.RemoveAt( (size_t) i1 );
}

//**************************************************************************************************
// Set the PDF file name.
//
// Argument List:
//   psFileName - a string containing the full path and file name
//
// Return Values:
//   true  - Success
//   false - Failure

bool  PrcPdfVwr::bSetPdfFile( const wxString & rosFileName )
{
  wxFileName  ofn1;

  ofn1 = rosFileName;
  if( ofn1.GetPath( ).IsEmpty( ) ) ofn1.SetPath( "." );

  if( ! ofn1.IsOk( )       ) return( false );
  if( ! ofn1.FileExists( ) ) return( false );

  m_ofnNamePdf = ofn1;

  return( true );
}

//**************************************************************************************************
// View the PDF file.
//
// Return Values:
//   true  - Success
//   false - Failure

bool  PrcPdfVwr::bExec( void )
{
  wxString  os1;

  // Check that a PDF file has been specified and is valid
  if( !m_ofnNamePdf.FileExists( ) || !m_ofnNamePdf.IsOk( ) )
  {
    os1 = m_ofnNamePdf.GetFullPath( );
    PrcBase::ClrErrMsg( );
    if( os1.IsEmpty( ) ) PrcBase::SetErrMsg( "The PDF file name has not been set." );
    else                 PrcBase::SetErrMsg( "The PDF file doesn't exist : " + os1 );
    return( false );
  }

  // Append the PDF file name to the argument list
  os1 = rosEscSpaceChrs( m_ofnNamePdf.GetFullPath( ) );
  if( ! bSetArgLst( os1 ) )      return( false );

  // Execute the process
  if( ! PrcBase::bExecAsync( ) ) return( false );

  return( true );
}

//**************************************************************************************************
