/* 
    Transformation.h: Zoom and rotate functions for SDL.
	modified from SDL_rotozoom.h, Copyright (C) A. Schiffler, July 2001

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef TRANSFORMATION_H
#define TRANSFORMATION_H

/* Set up for C function definitions, even when using C++ */
//#ifdef __cplusplus
//extern "C"
//{
//#endif

/* ---- Defines */

#define SMOOTHING_OFF		0
#define SMOOTHING_ON		1

#include <string.h>
#include <stdlib.h>

#include <math.h>
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif 

#include <SDL/SDL.h>

#define ZOOM_X_LIMIT 0.001
#define ZOOM_Y_LIMIT 0.001

#define PRECISION 256

#define VALUE_LIMIT	0.001

#ifndef MAX
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#endif

typedef struct tColorRGBA {
  Uint8 r;
  Uint8 g;
  Uint8 b;
  Uint8 a;
} tColorRGBA;

typedef struct tColorY {
  Uint8 y;
} tColorY;


/* 
 
 rotozoomSurface()

 Rotates and zoomes a 32bit or 8bit 'src' surface to newly created 'dst' surface.
 'angle' is the rotation in degrees. 'zoom' a scaling factor. If 'smooth' is 1
 then the destination 32bit surface is anti-aliased. If the surface is not 8bit
 or 32bit RGBA/ABGR it will be converted into a 32bit RGBA format on the fly.

*/

  SDL_Surface *roto_zoom_surface(SDL_Surface*, double, double,int);

/* 
 
 zoomSurface()

 Zoomes a 32bit or 8bit 'src' surface to newly created 'dst' surface.
 'zoomx' and 'zoomy' are scaling factors for width and height. If 'smooth' is 1
 then the destination 32bit surface is anti-aliased. If the surface is not 8bit
 or 32bit RGBA/ABGR it will be converted into a 32bit RGBA format on the fly.

*/

  SDL_Surface *zoom_surface (SDL_Surface*,double,double,int);


/* assuming surface 32 bits */

SDL_Surface* stack_up_surface(SDL_Surface*,SDL_Rect*,SDL_Surface*,SDL_Rect*);

/* Ends C function definitions when using C++ */

//#ifdef __cplusplus
//};
//#endif

#endif /*TRANSFORMATION_H*/
