/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpEntry;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationResultBuilder;
import org.gradle.security.internal.Fingerprint;

class WriterSignatureVerificationResult
implements SignatureVerificationResultBuilder {
    private final Set<String> ignoredKeys;
    private final PgpEntry entry;

    public WriterSignatureVerificationResult(Set<String> ignoredKeys, PgpEntry entry) {
        this.ignoredKeys = ignoredKeys;
        this.entry = entry;
    }

    @Override
    public void missingKey(String keyId) {
        this.ignoredKeys.add(keyId);
        this.entry.missing();
    }

    @Override
    public void verified(PGPPublicKey key, boolean trusted) {
        String keyId = Fingerprint.of((PGPPublicKey)key).toString();
        this.entry.addVerifiedKey(keyId);
    }

    @Override
    public void failed(PGPPublicKey key) {
        String keyId = Fingerprint.of((PGPPublicKey)key).toString();
        this.entry.fail(keyId);
    }

    @Override
    public void ignored(String keyId) {
        this.ignoredKeys.add(keyId);
    }
}

