/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CapabilitySerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.SelectedVariantSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.caching.DesugaringAttributeContainerSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;

@ThreadSafe
public class ThisBuildOnlySelectedVariantSerializer
implements SelectedVariantSerializer {
    private final Long2ObjectMap<VariantGraphResolveState> variants = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final Serializer<ComponentIdentifier> componentIdSerializer = new ComponentIdentifierSerializer();
    private final Serializer<AttributeContainer> attributeContainerSerializer;
    private final Serializer<List<Capability>> capabilitySerializer = new ListSerializer((Serializer)new CapabilitySerializer());

    public ThisBuildOnlySelectedVariantSerializer(ImmutableAttributesFactory immutableAttributesFactory, NamedObjectInstantiator namedObjectInstantiator) {
        this.attributeContainerSerializer = new DesugaringAttributeContainerSerializer(immutableAttributesFactory, namedObjectInstantiator);
    }

    @Override
    public void writeVariantResult(ResolvedGraphVariant variant, Encoder encoder) throws Exception {
        encoder.writeSmallLong(variant.getNodeId().longValue());
        VariantGraphResolveState state = variant.getResolveState();
        if (state.isAdHoc()) {
            this.writeVariantData(encoder, state);
        } else {
            this.writeVariantReference(encoder, variant, state);
        }
    }

    private void writeVariantReference(Encoder encoder, ResolvedGraphVariant variant, VariantGraphResolveState state) throws IOException {
        encoder.writeBoolean(false);
        this.writeVariantReference(encoder, state);
        ResolvedGraphVariant externalVariant = variant.getExternalVariant();
        if (externalVariant == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            this.writeVariantReference(encoder, externalVariant.getResolveState());
        }
    }

    private void writeVariantData(Encoder encoder, VariantGraphResolveState state) throws Exception {
        encoder.writeBoolean(true);
        ResolvedVariantResult variantResult = state.getVariantResult(null);
        this.componentIdSerializer.write(encoder, (Object)variantResult.getOwner());
        encoder.writeString((CharSequence)variantResult.getDisplayName());
        this.attributeContainerSerializer.write(encoder, (Object)variantResult.getAttributes());
        this.capabilitySerializer.write(encoder, (Object)variantResult.getCapabilities());
    }

    private void writeVariantReference(Encoder encoder, VariantGraphResolveState variant) throws IOException {
        long instanceId = variant.getInstanceId();
        this.variants.putIfAbsent(instanceId, (Object)variant);
        encoder.writeSmallLong(instanceId);
    }

    @Override
    public void readSelectedVariant(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        long nodeId = decoder.readSmallLong();
        if (decoder.readBoolean()) {
            this.readVariantData(decoder, visitor, nodeId);
        } else {
            this.readVariantReference(decoder, visitor, nodeId);
        }
    }

    private void readVariantReference(Decoder decoder, ResolvedComponentVisitor visitor, long nodeId) throws IOException {
        VariantGraphResolveState variant = this.readVariantReference(decoder);
        ResolvedVariantResult externalVariant = decoder.readBoolean() ? this.readVariantReference(decoder).getVariantResult(null) : null;
        visitor.visitSelectedVariant(nodeId, variant.getVariantResult(externalVariant));
    }

    private void readVariantData(Decoder decoder, ResolvedComponentVisitor visitor, long nodeId) throws Exception {
        ComponentIdentifier ownerId = (ComponentIdentifier)this.componentIdSerializer.read(decoder);
        String displayName = decoder.readString();
        AttributeContainer attributes = (AttributeContainer)this.attributeContainerSerializer.read(decoder);
        List capabilities = (List)this.capabilitySerializer.read(decoder);
        visitor.visitSelectedVariant(nodeId, new DefaultResolvedVariantResult(ownerId, Describables.of((Object)displayName), attributes, capabilities, null));
    }

    private VariantGraphResolveState readVariantReference(Decoder decoder) throws IOException {
        long instanceId = decoder.readSmallLong();
        VariantGraphResolveState variant = (VariantGraphResolveState)this.variants.get(instanceId);
        if (variant == null) {
            throw new IllegalStateException("No variant with id " + instanceId + " found.");
        }
        return variant;
    }
}

