/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import javax.annotation.Nullable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildTaskScheduler;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTaskExecutionPreparer
implements TaskExecutionPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildTaskScheduler buildTaskScheduler;
    private final BuildModelParameters buildModelParameters;

    public DefaultTaskExecutionPreparer(BuildTaskScheduler buildTaskScheduler, BuildOperationExecutor buildOperationExecutor, BuildModelParameters buildModelParameters) {
        this.buildTaskScheduler = buildTaskScheduler;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildModelParameters = buildModelParameters;
    }

    @Override
    public void scheduleRequestedTasks(GradleInternal gradle, @Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        gradle.getOwner().getProjects().withMutableStateOfAllProjects(() -> {
            this.buildTaskScheduler.scheduleRequestedTasks(gradle, selector, plan);
            if (this.buildModelParameters.isConfigureOnDemand() && gradle.isRootBuild()) {
                new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
            }
        });
    }
}

