/* ex: set tabstop=4 noet: */

#ifndef LANMAP_H
#define LANMAP_H

#define IFACE_MAX					4
#define IFACE_BUFLEN				64 /* win32 pcap device strs are hideous */



#ifdef WIN32
	#if defined(_MSC_VER) && _MSC_VER < 0x1300 /* Visual Studio 6 or below */
		#undef _WIN32_WINNT
		#define _WIN32_WINNT		0x0501
		#ifndef WIN32_LEAN_AND_MEAN
			#define WIN32_LEAN_AND_MEAN /* needed for VS6 */
		#endif
		#ifndef __FUNCTION__
			#define __FUNCTION__ ""
		#endif
	#endif
#endif

#ifdef WIN32
	#define LANMAP_PATH_SEP_CHR		'\\'
#else /* *NIX */
	#define LANMAP_PATH_SEP_CHR		'/'
#endif

#ifdef WIN32
	#ifndef LANMAP_DATADIR
		#define LANMAP_DATADIR		".."
	#endif
	#define xstr(s)					s
#else
	/* stringification magic <URL:http://developer.apple.com/documentation/DeveloperTools/gcc-3.3/cpp/Stringification.html> */
	#define xstr(s)					str(s)
	#define str(s)					#s
#endif

/* these guys MUST be prefixed with xstr(LANMAP_DATADIR) when used... sigh. i
can't figure out a decent way to get it into these #defines :/ */
#define MAC_VENDOR_FILE				"/data/mac_vendor"
#define DOT_HEADER_FILE				"/graph/lanmap.header"
#define ICON_DIR					"/graph/img"

#define DOT_FILE					"lanmap.dot" /* my output, dot's input */

#ifdef WIN32
	#define PATH_MAX	256
#endif

/* verbosity macros */
/* FIXME: ugly and unnecessary */
#define VERBOSE_MAX			4
#define V					if (Verbose > 1)
#define VV					if (Verbose > 2)
#define VVV					if (Verbose > 3)
#define VVVV				if (Verbose > 4)

#endif /* LANMAP_H */

