/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.rms;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.me4se.impl.rms.AbstractRecordStore;

public class RecordEnumerationImpl
implements RecordEnumeration,
RecordListener {
    AbstractRecordStore store;
    RecordFilter filter;
    RecordComparator comparator;
    boolean keepUpdated;
    Vector ids = new Vector();
    int currentIndex = -1;
    int indexCnt = 0;

    public RecordEnumerationImpl(AbstractRecordStore store, RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        store.checkOpen();
        this.store = store;
        this.filter = filter;
        this.comparator = comparator;
        this.keepUpdated = keepUpdated;
        this.loadRecords();
        if (keepUpdated) {
            System.out.println("[WARN] RecordEnumeration created with keepUpdated=true");
            store.addRecordListener(this);
        }
    }

    public void destroy() {
    }

    public boolean hasNextElement() {
        return this.currentIndex < this.indexCnt - 1;
    }

    public boolean hasPreviousElement() {
        return this.currentIndex >= 0;
    }

    public boolean isKeptUpdated() {
        return this.keepUpdated;
    }

    public void keepUpdated(boolean keepUpdated) {
        this.keepUpdated = keepUpdated;
        if (keepUpdated) {
            this.store.addRecordListener(this);
        } else {
            this.store.removeRecordListener(this);
        }
    }

    public byte[] nextRecord() throws RecordStoreException {
        return this.store.getRecord(this.nextRecordId());
    }

    public int nextRecordId() throws InvalidRecordIDException {
        if (!this.hasNextElement()) {
            throw new InvalidRecordIDException();
        }
        Integer id = (Integer)this.ids.elementAt(++this.currentIndex);
        return id;
    }

    public int numRecords() {
        return this.indexCnt;
    }

    public byte[] previousRecord() throws RecordStoreException {
        return this.store.getRecord(this.previousRecordId());
    }

    public int previousRecordId() throws InvalidRecordIDException {
        if (!this.hasPreviousElement()) {
            throw new InvalidRecordIDException();
        }
        Integer id = (Integer)this.ids.elementAt(--this.currentIndex);
        return id;
    }

    public void rebuild() {
        this.loadRecords();
    }

    public void reset() {
        this.currentIndex = -1;
    }

    private byte[] getRecord(int index) throws RecordStoreException {
        return this.store.getRecord((Integer)this.ids.elementAt(index));
    }

    private void loadRecords() {
        this.indexCnt = 0;
        this.ids = new Vector();
        int id = -1;
        int j = -1;
        int n = -1;
        byte[] record = null;
        byte[] tmpRecord = null;
        try {
            n = this.store.getNextRecordID();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        for (id = 1; id < n; ++id) {
            try {
                record = this.store.getRecord(id);
                if (record == null || this.filter != null && !this.filter.matches(record)) continue;
                if (this.comparator != null) {
                    boolean added = false;
                    for (j = 0; j < this.indexCnt; ++j) {
                        try {
                            tmpRecord = this.getRecord(j);
                            if (this.comparator.compare(record, tmpRecord) == 1) continue;
                            this.ids.insertElementAt(new Integer(id), j);
                            added = true;
                            break;
                        }
                        catch (RecordStoreException recordStoreException) {
                            // empty catch block
                        }
                    }
                    if (!added) {
                        this.ids.addElement(new Integer(id));
                    }
                } else {
                    this.ids.addElement(new Integer(id));
                }
                ++this.indexCnt;
                continue;
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
        this.indexCnt = this.ids.size();
    }

    public void recordAdded(RecordStore recordStore, int recordId) {
        this.loadRecords();
    }

    public void recordChanged(RecordStore recordStore, int recordId) {
        this.loadRecords();
    }

    public void recordDeleted(RecordStore recordStore, int recordId) {
        this.loadRecords();
    }
}

