/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.scm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.me4se.scm.ScmContainer;

public class ScmComponent {
    ScmContainer parent;
    int x;
    int y;
    int w;
    int h;
    Color background = null;
    boolean focusable;
    boolean invisible;
    protected boolean fullScreen;

    public boolean contains(int cx, int cy) {
        return cx >= 0 && cx <= this.w && cy >= 0 && cy <= this.h;
    }

    public ScmComponent getFocusOwner() {
        ScmContainer p = this.parent;
        if (p == null) {
            return null;
        }
        while (p.parent != null) {
            p = p.parent;
        }
        if (p.focus == null) {
            return null;
        }
        ScmComponent f;
        while ((f = p.focus) != null) {
            if (!(f instanceof ScmContainer)) {
                return f;
            }
            p = (ScmContainer)f;
        }
        return p;
    }

    public void doLayout() {
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public ScmContainer getParent() {
        return this.parent;
    }

    public boolean hasFocus() {
        return this == this.getFocusOwner();
    }

    public void invalidate() {
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public void paint(Graphics g) {
        if (this.background != null) {
            g.setColor(this.background);
            g.fillRect(0, 0, this.w, this.h);
        }
    }

    int getDepth() {
        return this.parent == null ? 1 : 1 + this.parent.getDepth();
    }

    public boolean scrollRequest(int x, int y, int w, int h) {
        return this.parent != null ? this.parent.scrollRequest(x + this.x, y + this.y, w, h) : false;
    }

    public boolean keyRepeated(String c) {
        return this.keyPressed(c);
    }

    public boolean keyPressed(String keyCode) {
        return false;
    }

    public boolean keyReleased(String keyCode) {
        return false;
    }

    public void mouseEntered() {
    }

    public void mouseExited() {
    }

    public boolean mouseClicked(int button, int x, int y, int modifiers, int clicks) {
        if (!this.focusable || this.hasFocus() || button != 1 || clicks != 1) {
            return false;
        }
        this.requestFocus();
        return true;
    }

    public boolean mouseReleased(int button, int x, int y, int modifiers) {
        return false;
    }

    public boolean mousePressed(int button, int x, int y, int modifiers) {
        return false;
    }

    public boolean mouseDragged(int x, int y, int modifiers) {
        return false;
    }

    public boolean mouseMoved(int x, int y, int modifiers) {
        return false;
    }

    public Color getBackground() {
        return this.background;
    }

    public Graphics getGraphics() {
        if (this.invisible) {
            return null;
        }
        if (this.parent == null) {
            return null;
        }
        Graphics g = this.parent.getGraphics();
        return g == null ? null : g.create(this.x, this.y, this.w, this.h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getSize() {
        return new Dimension(this.w, this.h);
    }

    public void requestFocus() {
        ScmComponent old = this.getFocusOwner();
        if (old == this) {
            return;
        }
        ScmComponent f = this;
        while (f.parent != null) {
            f.parent.focus = f;
            f = f.parent;
        }
        if (old != null) {
            old.focusLost();
            old.repaint();
        }
        this.focusGained();
        this.scrollRequest(0, 0, this.w, this.h);
        this.repaint();
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void focusLost() {
    }

    public void focusGained() {
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint(this.x, this.y, this.w, this.h);
        }
    }

    public void repaint(int x, int y, int w, int h) {
        if (this.parent != null) {
            this.parent.repaint(this.x + x, this.y + y, w, h);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.doLayout();
        this.invalidate();
    }

    public void setX(int x) {
        this.setBounds(x, this.y, this.w, this.h);
    }

    public void setY(int y) {
        this.setBounds(this.x, y, this.w, this.h);
    }

    public void setWidth(int w) {
        this.setBounds(this.x, this.y, w, this.h);
    }

    public void setHeight(int h) {
        this.setBounds(this.x, this.y, this.w, h);
    }

    public void setBackground(Color background) {
        this.background = background;
        this.repaint();
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public boolean getFocusable() {
        return this.focusable && !this.invisible;
    }

    public void setInvisible(boolean iv) {
        this.invisible = iv;
    }

    public boolean getInvisible() {
        return this.invisible;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }
}

