/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger = Logger.getLogger("");
    private Level level;

    public LoggingOutputStream(Level level) {
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public synchronized void flush() throws IOException {
        String record = this.toString();
        if (record.endsWith("\r\n") || record.endsWith("\n") || record.endsWith(this.lineSeparator)) {
            super.reset();
            record = record.endsWith("\r\n") ? record.substring(0, record.length() - 2) : (record.endsWith("\n") ? record.substring(0, record.length() - 1) : record.substring(0, record.length() - this.lineSeparator.length()));
            this.logger.log(this.level, record);
        }
    }
}

