/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.encryption.impl;

import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.encryption.impl.SecretKeySource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/gradle/internal/encryption/impl/EnvironmentVarKeySource;", "Lorg/gradle/internal/encryption/impl/SecretKeySource;", "encryptionAlgorithm", "", "(Ljava/lang/String;)V", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "Lkotlin/Lazy;", "sourceDescription", "getSourceDescription", "()Ljava/lang/String;", "getKey", "getKeyAsBase64", "Companion", "encryption-services"})
public final class EnvironmentVarKeySource
implements SecretKeySource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    public static final String GRADLE_ENCRYPTION_KEY_ENV_KEY = "GRADLE_ENCRYPTION_KEY";

    public EnvironmentVarKeySource(@NotNull String encryptionAlgorithm2) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm2, (String)"encryptionAlgorithm");
        this.secretKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecretKeySpec>(this, encryptionAlgorithm2){
            final /* synthetic */ EnvironmentVarKeySource this$0;
            final /* synthetic */ String $encryptionAlgorithm;
            {
                this.this$0 = $receiver;
                this.$encryptionAlgorithm = $encryptionAlgorithm;
                super(0);
            }

            @NotNull
            public final SecretKeySpec invoke() {
                byte[] byArray = Base64.getDecoder().decode(EnvironmentVarKeySource.access$getKeyAsBase64(this.this$0));
                String string = this.$encryptionAlgorithm;
                byte[] keyAsBytes = byArray;
                boolean bl = false;
                return new SecretKeySpec(keyAsBytes, string);
            }
        }));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final String getKeyAsBase64() {
        String string = System.getenv(GRADLE_ENCRYPTION_KEY_ENV_KEY);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public SecretKey getKey() {
        return this.getSecretKey();
    }

    @Override
    @NotNull
    public String getSourceDescription() {
        return "GRADLE_ENCRYPTION_KEY environment variable";
    }

    public static final /* synthetic */ String access$getKeyAsBase64(EnvironmentVarKeySource $this) {
        return $this.getKeyAsBase64();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/gradle/internal/encryption/impl/EnvironmentVarKeySource$Companion;", "", "()V", "GRADLE_ENCRYPTION_KEY_ENV_KEY", "", "encryption-services"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

