/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/PsiElementFinderByType;", "", "types", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "index", "", "depth", "reverse", "", "(Ljava/util/Collection;IIZ)V", "find", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "root", "visitElement", "element", "currentDepth", "checkers"})
public final class PsiElementFinderByType {
    @NotNull
    private final Collection<IElementType> types;
    private int index;
    private final int depth;
    private final boolean reverse;

    public PsiElementFinderByType(@NotNull Collection<? extends IElementType> types2, int index2, int depth, boolean reverse) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        this.types = types2;
        this.index = index2;
        this.depth = depth;
        this.reverse = reverse;
    }

    @Nullable
    public final PsiElement find(@NotNull PsiElement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.visitElement(root2, 0);
    }

    private final PsiElement visitElement(PsiElement element, int currentDepth) {
        Iterator<PsiElement> children2;
        if (currentDepth != 0 && this.types.contains(element.getNode().getElementType())) {
            if (this.index == 0) {
                return element;
            }
            int n = this.index;
            this.index = n + -1;
        }
        if (currentDepth == this.depth) {
            return null;
        }
        Iterator<PsiElement> iterator2 = children2 = this.reverse ? CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren(element))).iterator() : PsiUtilsKt.getAllChildren(element).iterator();
        while (iterator2.hasNext()) {
            PsiElement result2;
            PsiElement child = iterator2.next();
            PsiElement psiElement = result2 = this.visitElement(child, currentDepth + 1);
            if (psiElement == null) continue;
            return psiElement;
        }
        return null;
    }
}

