/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;

public final class ReadOnlyStyledDocumentBuilder<PS, SEG, S> {
    private final SegmentOps<SEG, S> segmentOps;
    private final PS defaultParagraphStyle;
    private final List<Paragraph<PS, SEG, S>> paragraphList;
    private boolean alreadyCreated = false;

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> constructDocument(SegmentOps<SEG, S> segmentOps, PS defaultParagraphStyle, Consumer<ReadOnlyStyledDocumentBuilder<PS, SEG, S>> configuration) {
        ReadOnlyStyledDocumentBuilder<PS, SEG, S> builder = new ReadOnlyStyledDocumentBuilder<PS, SEG, S>(segmentOps, defaultParagraphStyle);
        configuration.accept(builder);
        return builder.build();
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> constructDocument(SegmentOps<SEG, S> segmentOps, PS defaultParagraphStyle, int initialCapacity, Consumer<ReadOnlyStyledDocumentBuilder<PS, SEG, S>> configuration) {
        ReadOnlyStyledDocumentBuilder<PS, SEG, S> builder = new ReadOnlyStyledDocumentBuilder<PS, SEG, S>(segmentOps, defaultParagraphStyle, initialCapacity);
        configuration.accept(builder);
        return builder.build();
    }

    public ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS defaultParagraphStyle) {
        this(segmentOps, defaultParagraphStyle, new ArrayList<Paragraph<PS, SEG, S>>());
    }

    public ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS defaultParagraphStyle, int initialCapacity) {
        this(segmentOps, defaultParagraphStyle, new ArrayList<Paragraph<PS, SEG, S>>(initialCapacity));
    }

    private ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS defaultParagraphStyle, List<Paragraph<PS, SEG, S>> list) {
        this.segmentOps = segmentOps;
        this.defaultParagraphStyle = defaultParagraphStyle;
        this.paragraphList = list;
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<StyledSegment<SEG, S>> styledSegments) {
        return this.addParagraph((SEG)styledSegments, (S)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<StyledSegment<SEG, S>> styledSegments, PS paragraphStyle) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(paragraphStyle), this.segmentOps, styledSegments));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG segment, S style) {
        return this.addParagraph(segment, style, null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG segment, S style, PS paragraphStyle) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(paragraphStyle), this.segmentOps, segment, style));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG segment, StyleSpans<S> styles) {
        return this.addParagraph(segment, styles, (PS)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG segment, StyleSpans<S> styles, PS paragraphStyle) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(paragraphStyle), this.segmentOps, segment, styles));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<SEG> segments, StyleSpans<S> styles) {
        return this.addParagraph(segments, styles, (PS)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<SEG> segments, StyleSpans<S> styles, PS paragraphStyle) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(paragraphStyle), this.segmentOps, segments, styles));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphs(List<List<SEG>> listOfSegLists, StyleSpans<S> entireDocumentStyleSpans) {
        return this.addParagraphList(listOfSegLists, entireDocumentStyleSpans, ignore -> null, Function.identity());
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphs0(List<Tuple2<PS, List<SEG>>> paragraphArgList, StyleSpans<S> entireDocumentStyleSpans) {
        return this.addParagraphList(paragraphArgList, entireDocumentStyleSpans, Tuple2::get1, Tuple2::get2);
    }

    public ReadOnlyStyledDocument<PS, SEG, S> build() {
        this.ensureNotYetCreated();
        if (this.paragraphList.isEmpty()) {
            throw new IllegalStateException("Cannot build a ReadOnlyStyledDocument with an empty list of paragraphs!");
        }
        this.alreadyCreated = true;
        return new ReadOnlyStyledDocument<PS, SEG, S>(this.paragraphList);
    }

    private <T> ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphList(List<T> paragraphContentList, StyleSpans<S> spansThroughoutDocument, Function<T, PS> getStyle, Function<T, List<SEG>> getSegList) {
        int docLength = paragraphContentList.stream().map(getSegList).flatMap(l -> l.stream().map(this.segmentOps::length)).reduce(0, (a, b) -> a + b);
        if (docLength != spansThroughoutDocument.length()) {
            throw new IllegalArgumentException(String.format("Document length does not equal style spans length! docLength=%s styleSpans' length=%s", docLength, spansThroughoutDocument.length()));
        }
        int styleOffset = 0;
        for (T paragraphContent : paragraphContentList) {
            PS paragraphStyle = this.argumentOrDefault(getStyle.apply(paragraphContent));
            List<SEG> segList = getSegList.apply(paragraphContent);
            int paragraphLength = segList.stream().mapToInt(this.segmentOps::length).sum();
            int styleEnd = styleOffset + paragraphLength;
            StyleSpans<S> spans = spansThroughoutDocument.subView(styleOffset, styleEnd);
            this.addPar(new Paragraph<PS, SEG, S>(paragraphStyle, this.segmentOps, segList, spans));
            styleOffset = styleEnd;
        }
        return this;
    }

    private PS argumentOrDefault(PS paragraphStyle) {
        return paragraphStyle != null ? paragraphStyle : this.defaultParagraphStyle;
    }

    private void ensureNotYetCreated() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("This builder has already been used to create a list of Paragraphs. One builder can only be used to build a single list. To create a new one, create a new builder");
        }
    }

    private ReadOnlyStyledDocumentBuilder<PS, SEG, S> addPar(Paragraph<PS, SEG, S> paragraph) {
        this.ensureNotYetCreated();
        this.paragraphList.add(paragraph);
        return this;
    }
}

