/*
 * Decompiled with CFR 0.152.
 */
package org.jabref;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jabref.FallbackExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefExecutorService {
    public static final JabRefExecutorService INSTANCE = new JabRefExecutorService();
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefExecutorService.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("JabRef CachedThreadPool");
        thread.setUncaughtExceptionHandler(new FallbackExceptionHandler());
        return thread;
    });
    private final ExecutorService lowPriorityExecutorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("JabRef LowPriorityCachedThreadPool");
        thread.setUncaughtExceptionHandler(new FallbackExceptionHandler());
        return thread;
    });
    private final Timer timer = new Timer("timer", true);
    private Thread remoteThread;

    private JabRefExecutorService() {
    }

    public void execute(Runnable command) {
        Objects.requireNonNull(command);
        this.executorService.execute(command);
    }

    public void executeAndWait(Runnable command) {
        Objects.requireNonNull(command);
        Future<?> future = this.executorService.submit(command);
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOGGER.error("Problem executing command", e);
        }
    }

    public <T> Future<T> execute(Callable<T> command) {
        Objects.requireNonNull(command);
        return this.executorService.submit(command);
    }

    public <T> List<Future<T>> executeAll(Collection<Callable<T>> tasks) {
        Objects.requireNonNull(tasks);
        try {
            return this.executorService.invokeAll(tasks);
        }
        catch (InterruptedException exception) {
            return Collections.emptyList();
        }
    }

    public <T> List<Future<T>> executeAll(Collection<Callable<T>> tasks, int timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(tasks);
        try {
            return this.executorService.invokeAll(tasks, timeout, timeUnit);
        }
        catch (InterruptedException exception) {
            return Collections.emptyList();
        }
    }

    public void executeInterruptableTask(Runnable runnable, String taskName) {
        this.lowPriorityExecutorService.execute(new NamedRunnable(taskName, runnable));
    }

    public void executeInterruptableTaskAndWait(Runnable runnable) {
        Objects.requireNonNull(runnable);
        Future<?> future = this.lowPriorityExecutorService.submit(runnable);
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOGGER.error("Problem executing command", e);
        }
    }

    public void manageRemoteThread(Thread thread) {
        if (this.remoteThread != null) {
            throw new IllegalStateException("Remote thread is already attached");
        }
        this.remoteThread = thread;
        this.remoteThread.start();
    }

    public void stopRemoteThread() {
        if (this.remoteThread != null) {
            this.remoteThread.interrupt();
            this.remoteThread = null;
        }
    }

    public void submit(TimerTask timerTask, long millisecondsDelay) {
        this.timer.schedule(timerTask, millisecondsDelay);
    }

    public void shutdownEverything() {
        this.executorService.shutdown();
        this.lowPriorityExecutorService.shutdownNow();
        this.stopRemoteThread();
    }

    private class NamedRunnable
    implements Runnable {
        private final String name;
        private final Runnable task;

        private NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.task = runnable;
        }

        @Override
        public void run() {
            String orgName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.name);
            try {
                this.task.run();
            }
            finally {
                Thread.currentThread().setName(orgName);
            }
        }
    }
}

