/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.filelist.FileListEntryEditor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadExternalFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadExternalFile.class);
    private final JabRefFrame frame;
    private final BibDatabaseContext databaseContext;
    private final BibEntry entry;
    private FileListEntryEditor editor;
    private boolean downloadFinished;
    private boolean dontShowDialog;

    public DownloadExternalFile(JabRefFrame frame, BibDatabaseContext databaseContext, BibEntry entry) {
        this.frame = frame;
        this.databaseContext = databaseContext;
        this.entry = entry;
    }

    public static String getSuffix(String link) {
        String strippedLink = link;
        try {
            URL url = new URL(link);
            if (url.getQuery() != null && url.getQuery().length() < link.length() - 1) {
                strippedLink = link.substring(0, link.length() - url.getQuery().length() - 1);
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        int strippedLinkIndex = strippedLink.lastIndexOf(46);
        String suffix = strippedLinkIndex <= 0 || strippedLinkIndex == strippedLink.length() - 1 ? null : strippedLink.substring(strippedLinkIndex + 1);
        if (!ExternalFileTypes.getInstance().isExternalFileTypeByExt(suffix)) {
            int index = link.lastIndexOf(46);
            if (index <= 0 || index == link.length() - 1) {
                if (strippedLink.substring(strippedLinkIndex + 1).indexOf(47) >= 1) {
                    return "";
                }
                return suffix;
            }
            if (link.substring(index + 1).indexOf(47) >= 1) {
                return "";
            }
            return link.substring(index + 1);
        }
        return suffix;
    }

    public void download(DownloadCallback callback) throws IOException {
        URL url;
        this.dontShowDialog = false;
        String res = JOptionPane.showInputDialog(this.frame, (Object)Localization.lang("Enter URL to download", new String[0]));
        if (res == null || res.trim().isEmpty()) {
            return;
        }
        try {
            url = new URL(res);
        }
        catch (MalformedURLException ex1) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Invalid URL", new String[0]), Localization.lang("Download file", new String[0]), 0);
            return;
        }
        this.download(url, callback);
    }

    public void download(URL url, DownloadCallback callback) throws IOException {
        String mimeType = new URLDownload(url).getMimeType();
        this.download(url, mimeType, callback);
    }

    private Optional<ExternalFileType> getExternalFileType(String mimeType) {
        Optional<ExternalFileType> suggestedType = Optional.empty();
        if (mimeType != null) {
            LOGGER.debug("MIME Type suggested: " + mimeType);
            suggestedType = ExternalFileTypes.getInstance().getExternalFileTypeByMimeType(mimeType);
        }
        return suggestedType;
    }

    public void download(URL url, String mimeType, DownloadCallback callback) throws IOException {
        String suffix;
        Optional<ExternalFileType> fileType = this.getExternalFileType(mimeType);
        Path tempFile = Files.createTempFile("jabref_download", "tmp", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        URLDownload fileDownload = new URLDownload(url);
        JabRefExecutorService.INSTANCE.execute(() -> {
            try {
                fileDownload.toFile(tempFile);
            }
            catch (IOException e) {
                this.dontShowDialog = true;
                if (this.editor != null && this.editor.isVisible()) {
                    this.editor.setVisible(false, false);
                }
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Invalid URL", new String[0]) + ": " + e.getMessage(), Localization.lang("Download file", new String[0]), 0);
                LOGGER.info("Error while downloading '" + url + "'", e);
                return;
            }
            SwingUtilities.invokeLater(this::downloadFinished);
        });
        if (fileType.isPresent()) {
            suffix = fileType.get().getExtension();
        } else {
            suffix = DownloadExternalFile.getSuffix(url.toString());
            if (suffix == null) {
                suffix = "";
            }
            fileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt(suffix);
        }
        String suggestedName = this.getSuggestedFileName(suffix);
        List<String> fDirectory = this.databaseContext.getFileDirectories(Globals.prefs.getFileDirectoryPreferences());
        String directory = fDirectory.isEmpty() ? null : fDirectory.get(0);
        String suggestDir = directory == null ? System.getProperty("user.home") : directory;
        File file = new File(new File(suggestDir), suggestedName);
        LinkedFile fileListEntry = new LinkedFile("", file.getCanonicalPath(), fileType.map(ExternalFileType::getName).orElse(""));
        this.editor = new FileListEntryEditor(fileListEntry, true, false, this.databaseContext, true);
        this.editor.getProgressBar().setIndeterminate(true);
        this.editor.setOkEnabled(false);
        this.editor.setExternalConfirm(closeEntry -> {
            File f;
            File file = f = directory == null ? new File(closeEntry.getLink()) : this.expandFilename(directory, closeEntry.getLink());
            if (f.isDirectory()) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Target file cannot be a directory.", new String[0]), Localization.lang("Download file", new String[0]), 0);
                return false;
            }
            if (f.exists()) {
                return JOptionPane.showConfirmDialog(this.frame, Localization.lang("'%0' exists. Overwrite file?", f.getName()), Localization.lang("Download file", new String[0]), 2) == 0;
            }
            return true;
        });
        if (this.dontShowDialog) {
            return;
        }
        this.editor.setVisible(true, false);
        if (this.editor.okPressed()) {
            File toFile;
            File file2 = toFile = directory == null ? new File(fileListEntry.getLink()) : this.expandFilename(directory, fileListEntry.getLink());
            String dirPrefix = directory == null ? null : (directory.endsWith(OS.FILE_SEPARATOR) ? directory : directory + OS.FILE_SEPARATOR);
            boolean success = FileUtil.copyFile(tempFile, Paths.get(toFile.toURI()), true);
            if (!success) {
                LOGGER.error("File already exists! DownloadExternalFile.download()");
            }
            if (dirPrefix != null && fileListEntry.getLink().startsWith(directory) && fileListEntry.getLink().length() > dirPrefix.length()) {
                fileListEntry = new LinkedFile(fileListEntry.getDescription(), fileListEntry.getLink().substring(dirPrefix.length()), fileListEntry.getFileType());
            }
            callback.downloadComplete(fileListEntry);
            if (!Files.deleteIfExists(tempFile)) {
                LOGGER.info("Cannot delete temporary file");
            }
        } else if (this.downloadFinished && !Files.deleteIfExists(tempFile)) {
            LOGGER.info("Cannot delete temporary file");
        }
    }

    private File expandFilename(String directory, String link) {
        File toFile = new File(link);
        String dirPrefix = directory + OS.FILE_SEPARATOR;
        if (!toFile.isAbsolute()) {
            toFile = new File(dirPrefix + link);
        }
        return toFile;
    }

    private void downloadFinished() {
        this.downloadFinished = true;
        this.editor.getProgressBar().setVisible(false);
        this.editor.getProgressBarLabel().setVisible(false);
        this.editor.setOkEnabled(true);
        this.editor.getProgressBar().setValue(this.editor.getProgressBar().getMaximum());
    }

    private String getSuggestedFileName(String suffix) {
        String plannedName = FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), this.entry, Globals.prefs.get("importFileNamePattern"));
        if (!suffix.isEmpty()) {
            plannedName = plannedName + "." + suffix;
        }
        if (OS.WINDOWS) {
            plannedName = plannedName.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
        } else if (OS.OS_X) {
            plannedName = plannedName.replace(":", "");
        }
        return plannedName;
    }

    @FunctionalInterface
    public static interface DownloadCallback {
        public void downloadComplete(LinkedFile var1);
    }
}

