/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.Collection;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.JabRefGUI;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.model.entry.BibEntry;

public class AbstractEditorViewModel
extends AbstractViewModel {
    protected final String fieldName;
    protected StringProperty text = new SimpleStringProperty("");
    protected BibEntry entry;
    private final AutoCompleteSuggestionProvider<?> suggestionProvider;
    private final CompositeValidator fieldValidator;
    private ObjectBinding<String> fieldBinding;

    public AbstractEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        this.fieldName = fieldName;
        this.suggestionProvider = suggestionProvider;
        this.fieldValidator = new CompositeValidator();
        for (ValueChecker checker : fieldCheckers.getForField(fieldName)) {
            FunctionBasedValidator<String> validator = new FunctionBasedValidator<String>((ObservableValue<String>)this.text, value -> checker.checkValue((String)value).map(ValidationMessage::warning).orElse(null));
            this.fieldValidator.addValidators(validator);
        }
    }

    public Validator getFieldValidator() {
        return this.fieldValidator;
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void bindToEntry(BibEntry entry) {
        this.entry = entry;
        this.fieldBinding = entry.getFieldBinding(this.fieldName);
        BindingsHelper.bindBidirectional(this.textProperty(), this.fieldBinding, newValue -> {
            if (newValue != null) {
                String oldValue = entry.getField(this.fieldName).orElse(null);
                entry.setField(this.fieldName, (String)newValue);
                CountingUndoManager undoManager = JabRefGUI.getMainFrame().getCurrentBasePanel().getUndoManager();
                ((UndoManager)undoManager).addEdit(new UndoableFieldChange(entry, this.fieldName, oldValue, (String)newValue));
            }
        });
    }

    public Collection<?> complete(AutoCompletionBinding.ISuggestionRequest request) {
        return (Collection)this.suggestionProvider.call(request);
    }
}

