/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.time.format.DateTimeFormatter;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.layout.HBox;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.DateEditorViewModel;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.component.TemporalAccessorPicker;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;

public class DateEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private DateEditorViewModel viewModel;
    @FXML
    private TemporalAccessorPicker datePicker;

    public DateEditor(String fieldName, DateTimeFormatter dateFormatter, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        this.viewModel = new DateEditorViewModel(fieldName, suggestionProvider, dateFormatter, fieldCheckers);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.datePicker.setStringConverter(this.viewModel.getDateToStringConverter());
        this.datePicker.getEditor().textProperty().bindBidirectional((Property)this.viewModel.textProperty());
    }

    public DateEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

