/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.Optional;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.IdentifierEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldName;
import org.jabref.preferences.JabRefPreferences;

public class IdentifierEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private IdentifierEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;
    @FXML
    private Button fetchInformationByIdentifierButton;
    @FXML
    private Button lookupIdentifierButton;
    private Optional<BibEntry> entry;

    public IdentifierEditor(String fieldName, TaskExecutor taskExecutor, DialogService dialogService, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, JabRefPreferences preferences) {
        this.viewModel = new IdentifierEditorViewModel(fieldName, suggestionProvider, taskExecutor, dialogService, fieldCheckers);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.textArea.textProperty().bindBidirectional((Property)this.viewModel.textProperty());
        this.fetchInformationByIdentifierButton.setTooltip(new Tooltip(Localization.lang("Get BibTeX data from %0", FieldName.getDisplayName(fieldName))));
        this.lookupIdentifierButton.setTooltip(new Tooltip(Localization.lang("Look up %0", FieldName.getDisplayName(fieldName))));
        if (fieldName.equalsIgnoreCase("doi")) {
            this.textArea.addToContextMenu(EditorMenus.getDOIMenu(this.textArea));
        } else {
            this.textArea.addToContextMenu(EditorMenus.getDefaultMenu(this.textArea));
        }
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), this.textArea);
    }

    public IdentifierEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.entry = Optional.of(entry);
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void fetchInformationByIdentifier(ActionEvent event) {
        this.entry.ifPresent(bibEntry -> this.viewModel.fetchInformationByIdentifier((BibEntry)bibEntry));
    }

    @FXML
    private void lookupIdentifier(ActionEvent event) {
        this.entry.ifPresent(bibEntry -> this.viewModel.lookupIdentifier((BibEntry)bibEntry));
    }

    @FXML
    private void openExternalLink(ActionEvent event) {
        this.viewModel.openExternalLink();
    }
}

