/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.strings.StringUtil;

public class GroupDescriptions {
    private GroupDescriptions() {
    }

    public static String getDescriptionForPreview(String field2, String expr, boolean caseSensitive, boolean regExp) {
        String header = regExp ? Localization.lang("This group contains entries whose <b>%0</b> field contains the regular expression <b>%1</b>", field2, StringUtil.quoteForHTML(expr)) : Localization.lang("This group contains entries whose <b>%0</b> field contains the keyword <b>%1</b>", field2, StringUtil.quoteForHTML(expr));
        String caseSensitiveText = caseSensitive ? Localization.lang("case sensitive", new String[0]) : Localization.lang("case insensitive", new String[0]);
        String footer = regExp ? Localization.lang("Entries cannot be manually assigned to or removed from this group.", new String[0]) : Localization.lang("Additionally, entries whose <b>%0</b> field does not contain <b>%1</b> can be assigned manually to this group by selecting them then using either drag and drop or the context menu. This process adds the term <b>%1</b> to each entry's <b>%0</b> field. Entries can be removed manually from this group by selecting them then using the context menu. This process removes the term <b>%1</b> from each entry's <b>%0</b> field.", field2, StringUtil.quoteForHTML(expr));
        return String.format("%s (%s). %s", header, caseSensitiveText, footer);
    }

    public static String getShortDescriptionKeywordGroup(KeywordGroup keywordGroup, boolean showDynamic) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        if (showDynamic) {
            sb.append("<i>").append(StringUtil.quoteForHTML(keywordGroup.getName())).append("</i>");
        } else {
            sb.append(StringUtil.quoteForHTML(keywordGroup.getName()));
        }
        sb.append("</b> - ");
        sb.append(Localization.lang("dynamic group", new String[0]));
        sb.append(" <b>");
        sb.append(keywordGroup.getSearchField());
        sb.append("</b> ");
        sb.append(Localization.lang("contains", new String[0]));
        sb.append(" <b>");
        sb.append(StringUtil.quoteForHTML(keywordGroup.getSearchExpression()));
        sb.append("</b>)");
        switch (keywordGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new String[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new String[0]));
                break;
            }
        }
        return sb.toString();
    }

    public static String getDescriptionForPreview() {
        return Localization.lang("This group contains entries based on manual assignment. Entries can be assigned to this group by selecting them then using either drag and drop or the context menu. Entries can be removed from this group by selecting them then using the context menu.", new String[0]);
    }

    public static String getShortDescriptionExplicitGroup(ExplicitGroup explicitGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(explicitGroup.getName()).append("</b> - ").append(Localization.lang("static group", new String[0]));
        switch (explicitGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new String[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new String[0]));
                break;
            }
        }
        return sb.toString();
    }

    public static String getShortDescriptionAllEntriesGroup() {
        return Localization.lang("<b>All Entries</b> (this group cannot be edited or removed)", new String[0]);
    }

    public static String getShortDescription(SearchGroup searchGroup, boolean showDynamic) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        if (showDynamic) {
            sb.append("<i>").append(StringUtil.quoteForHTML(searchGroup.getName())).append("</i>");
        } else {
            sb.append(StringUtil.quoteForHTML(searchGroup.getName()));
        }
        sb.append("</b> - ");
        sb.append(Localization.lang("dynamic group", new String[0]));
        sb.append(" (");
        sb.append(Localization.lang("search expression", new String[0]));
        sb.append(" <b>").append(StringUtil.quoteForHTML(searchGroup.getSearchExpression())).append("</b>)");
        switch (searchGroup.getHierarchicalContext()) {
            case INCLUDING: {
                sb.append(", ").append(Localization.lang("includes subgroups", new String[0]));
                break;
            }
            case REFINING: {
                sb.append(", ").append(Localization.lang("refines supergroup", new String[0]));
                break;
            }
        }
        return sb.toString();
    }
}

