/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.CompoundEdit;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.MergeDialog;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntry;
import org.jabref.gui.undo.UndoableInsertString;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendDatabaseAction
implements BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendDatabaseAction.class);
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final List<Path> filesToOpen = new ArrayList<Path>();

    public AppendDatabaseAction(JabRefFrame frame, BasePanel panel) {
        this.frame = frame;
        this.panel = panel;
    }

    private static void mergeFromBibtex(BasePanel panel, ParserResult parserResult, boolean importEntries, boolean importStrings, boolean importGroups, boolean importSelectorWords) throws KeyCollisionException {
        BibDatabase fromDatabase = parserResult.getDatabase();
        ArrayList<BibEntry> appendedEntries = new ArrayList<BibEntry>();
        ArrayList<BibEntry> originalEntries = new ArrayList<BibEntry>();
        BibDatabase database = panel.getDatabase();
        NamedCompound ce = new NamedCompound(Localization.lang("Append library", new String[0]));
        MetaData meta = parserResult.getMetaData();
        if (importEntries) {
            boolean overwriteOwner = Globals.prefs.getBoolean("overwriteOwner");
            boolean overwriteTimeStamp = Globals.prefs.getTimestampPreferences().overwriteTimestamp();
            for (BibEntry originalEntry : fromDatabase.getEntries()) {
                BibEntry entry = (BibEntry)originalEntry.clone();
                UpdateField.setAutomaticFields(entry, overwriteOwner, overwriteTimeStamp, Globals.prefs.getUpdateFieldPreferences());
                database.insertEntry(entry);
                appendedEntries.add(entry);
                originalEntries.add(originalEntry);
                ce.addEdit(new UndoableInsertEntry(database, entry, panel));
            }
        }
        if (importStrings) {
            for (BibtexString bs : fromDatabase.getStringValues()) {
                if (database.hasStringLabel(bs.getName())) continue;
                database.addString(bs);
                ce.addEdit(new UndoableInsertString(panel, database, bs));
            }
        }
        if (importGroups) {
            meta.getGroups().ifPresent(newGroups -> {
                if (newGroups.getGroup() instanceof AllEntriesGroup) {
                    try {
                        ExplicitGroup group = new ExplicitGroup("Imported", GroupHierarchyType.INDEPENDENT, Globals.prefs.getKeywordDelimiter());
                        newGroups.setGroup(group);
                        group.add(appendedEntries);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Problem appending entries to group", e);
                    }
                }
                AppendDatabaseAction.addGroups(newGroups, ce);
            });
        }
        if (importSelectorWords) {
            for (ContentSelector selector : meta.getContentSelectorList()) {
                panel.getBibDatabaseContext().getMetaData().addContentSelector(selector);
            }
        }
        ce.end();
        panel.getUndoManager().addEdit(ce);
        panel.markBaseChanged();
    }

    private static void addGroups(GroupTreeNode newGroups, CompoundEdit ce) {
        if (newGroups.getGroup() instanceof AllEntriesGroup) {
            return;
        }
        Globals.stateManager.getActiveDatabase().map(BibDatabaseContext::getMetaData).flatMap(MetaData::getGroups).ifPresent(newGroups::moveTo);
    }

    @Override
    public void action() {
        this.filesToOpen.clear();
        MergeDialog dialog = new MergeDialog(this.frame, Localization.lang("Append library", new String[0]), true);
        dialog.setLocationRelativeTo(this.panel);
        dialog.setVisible(true);
        if (dialog.isOkPressed()) {
            FXDialogService dialogService = new FXDialogService();
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            List chosen = DefaultTaskExecutor.runInJavaFXThread(() -> dialogService.showFileOpenDialogAndGetMultipleFiles(fileDialogConfiguration));
            if (chosen.isEmpty()) {
                return;
            }
            this.filesToOpen.addAll(chosen);
            JabRefExecutorService.INSTANCE.execute(() -> this.openIt(dialog.importEntries(), dialog.importStrings(), dialog.importGroups(), dialog.importSelectorWords()));
        }
    }

    private void openIt(boolean importEntries, boolean importStrings, boolean importGroups, boolean importSelectorWords) {
        if (this.filesToOpen.isEmpty()) {
            return;
        }
        for (Path file : this.filesToOpen) {
            try {
                Globals.prefs.put("workingDirectory", file.getParent().toString());
                ParserResult parserResult = OpenDatabase.loadDatabase(file.toFile(), Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor());
                AppendDatabaseAction.mergeFromBibtex(this.panel, parserResult, importEntries, importStrings, importGroups, importSelectorWords);
                this.panel.output(Localization.lang("Imported from library", new String[0]) + " '" + file + "'");
            }
            catch (IOException | KeyCollisionException ex) {
                LOGGER.warn("Could not open database", ex);
                JOptionPane.showMessageDialog(this.panel, ex.getMessage(), Localization.lang("Open library", new String[0]), 0);
            }
        }
    }
}

