/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.importer.fetcher.EntryFetcher;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.ImportInspector;
import org.jabref.logic.importer.OutputPrinter;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiteSeerXFetcher
implements EntryFetcher {
    private static final int MAX_PAGES_TO_LOAD = 8;
    private static final String QUERY_MARKER = "___QUERY___";
    private static final String URL_START = "http://citeseer.ist.psu.edu";
    private static final String SEARCH_URL = "http://citeseer.ist.psu.edu/search?q=___QUERY___&submit=Search&sort=rlv&t=doc";
    private static final Pattern CITE_LINK_PATTERN = Pattern.compile("<a class=\"remove doc_details\" href=\"(.*)\">");
    private static final String BASE_PATTERN = "<meta name=\"___QUERY___\" content=\"(.*)\" />";
    private static final Pattern TITLE_PATTERN = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_title"));
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_authors"));
    private static final Pattern YEAR_PATTERN = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_year"));
    private static final Pattern ABSTRACT_PATTERN = Pattern.compile("<h3>Abstract</h3>\\s*<p>(.*)</p>");
    private static final Logger LOGGER = LoggerFactory.getLogger(CiteSeerXFetcher.class);
    private boolean stopFetching;

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query);
            for (String citation : citations) {
                if (this.stopFetching) break;
                BibEntry entry = CiteSeerXFetcher.getSingleCitation(citation);
                if (entry == null) continue;
                inspector.addEntry(entry);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)inspector).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "CiteSeerX";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_CITESEERX;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    private List<String> getCitations(String query) throws IOException {
        String nextPage;
        ArrayList<String> ids = new ArrayList<String>();
        String urlQuery = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(query, StandardCharsets.UTF_8.name()));
        for (int count = 1; (nextPage = CiteSeerXFetcher.getCitationsFromUrl(urlQuery, ids)) != null && count < 8; ++count) {
            urlQuery = nextPage;
            if (!this.stopFetching) continue;
            break;
        }
        return ids;
    }

    private static String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        String cont = new URLDownload(urlQuery).asString(Globals.prefs.getDefaultEncoding());
        Matcher m3 = CITE_LINK_PATTERN.matcher(cont);
        while (m3.find()) {
            ids.add(URL_START + m3.group(1));
        }
        return null;
    }

    private static BibEntry getSingleCitation(String urlString) throws IOException {
        String cont = new URLDownload(urlString).asString();
        Matcher m3 = TITLE_PATTERN.matcher(cont);
        if (m3.find()) {
            BibEntry entry = new BibEntry();
            entry.setField("title", m3.group(1));
            m3 = AUTHOR_PATTERN.matcher(cont);
            if (m3.find()) {
                String authors = m3.group(1);
                entry.setField("author", new NormalizeNamesFormatter().format(authors));
            }
            if ((m3 = YEAR_PATTERN.matcher(cont)).find()) {
                entry.setField("year", m3.group(1));
            }
            if ((m3 = ABSTRACT_PATTERN.matcher(cont)).find()) {
                entry.setField("abstract", m3.group(1));
            }
            return entry;
        }
        return null;
    }
}

