/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.journals.UndoableAbbreviator;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.InternalBibtexFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbbreviateAction
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbbreviateAction.class);
    private final BasePanel panel;
    private String message = "";
    private final boolean iso;

    public AbbreviateAction(BasePanel panel, boolean iso) {
        this.panel = panel;
        this.iso = iso;
    }

    @Override
    public void init() {
        this.panel.output(Localization.lang("Abbreviating...", new String[0]));
    }

    @Override
    public void run() {
        List<BibEntry> entries = this.panel.getSelectedEntries();
        UndoableAbbreviator undoableAbbreviator = new UndoableAbbreviator(Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences()), this.iso);
        NamedCompound ce = new NamedCompound(Localization.lang("Abbreviate journal names", new String[0]));
        HashSet tasks = new HashSet();
        for (BibEntry entry : entries) {
            Callable<Boolean> callable = () -> {
                for (String journalField : InternalBibtexFields.getJournalNameFields()) {
                    if (!undoableAbbreviator.abbreviate(this.panel.getDatabase(), entry, journalField, ce)) continue;
                    return true;
                }
                return false;
            };
            tasks.add(callable);
        }
        List futures = JabRefExecutorService.INSTANCE.executeAll(tasks);
        long count = futures.stream().filter(future -> {
            try {
                return (Boolean)future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.error("Unable to retrieve value.", exception);
                return false;
            }
        }).count();
        if (count > 0L) {
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
            this.message = Localization.lang("Abbreviated %0 journal names.", String.valueOf(count));
        } else {
            this.message = Localization.lang("No journal names could be abbreviated.", new String[0]);
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

