/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javax.swing.KeyStroke;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.util.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyBindingRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyBindingRepository.class);
    private final SortedMap<KeyBinding, String> bindings = new TreeMap<KeyBinding, String>(Comparator.comparing(KeyBinding::getLocalization));
    private int shortcutMask = -1;

    public KeyBindingRepository() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public KeyBindingRepository(List<String> bindNames, List<String> bindings) {
        if (bindNames.isEmpty() || bindings.isEmpty() || bindNames.size() != bindings.size()) {
            for (KeyBinding keyBinding : KeyBinding.values()) {
                this.put(keyBinding, keyBinding.getDefaultKeyBinding());
            }
        } else {
            for (int i = 0; i < bindNames.size(); ++i) {
                this.put(bindNames.get(i), bindings.get(i));
            }
        }
    }

    public static boolean checkKeyCombinationEquality(KeyCombination combination, KeyEvent keyEvent) {
        KeyCode code = keyEvent.getCode();
        if (code == KeyCode.UNDEFINED) {
            return false;
        }
        return combination.match(keyEvent);
    }

    public Optional<String> get(KeyBinding key) {
        return Optional.ofNullable((String)this.bindings.get((Object)key));
    }

    public String get(String key) {
        Optional<KeyBinding> keyBinding = this.getKeyBinding(key);
        Optional result = keyBinding.flatMap(k -> Optional.ofNullable((String)this.bindings.get(k)));
        if (result.isPresent()) {
            return (String)result.get();
        }
        if (keyBinding.isPresent()) {
            return keyBinding.get().getDefaultKeyBinding();
        }
        return "Not associated";
    }

    public SortedMap<KeyBinding, String> getKeyBindings() {
        return new TreeMap<KeyBinding, String>(this.bindings);
    }

    public void put(KeyBinding key, String value) {
        this.bindings.put(key, value);
    }

    public void put(String key, String value) {
        this.getKeyBinding(key).ifPresent(binding -> this.put((KeyBinding)((Object)binding), value));
    }

    private Optional<KeyBinding> getKeyBinding(String key) {
        return Arrays.stream(KeyBinding.values()).filter(b -> b.getConstant().equals(key)).findFirst();
    }

    public void resetToDefault(String key) {
        this.getKeyBinding(key).ifPresent(b -> this.bindings.put((KeyBinding)((Object)b), b.getDefaultKeyBinding()));
    }

    public void resetToDefault() {
        this.bindings.forEach((b, s2) -> this.bindings.put((KeyBinding)((Object)b), b.getDefaultKeyBinding()));
    }

    public int size() {
        return this.bindings.size();
    }

    public Optional<KeyBinding> mapToKeyBinding(KeyEvent keyEvent) {
        for (KeyBinding binding : KeyBinding.values()) {
            if (!this.checkKeyCombinationEquality(binding, keyEvent)) continue;
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    public Optional<KeyBinding> mapToKeyBinding(java.awt.event.KeyEvent keyEvent) {
        Optional<KeyCode> keyCode = Arrays.stream(KeyCode.values()).filter(k -> k.impl_getCode() == keyEvent.getKeyCode()).findFirst();
        if (keyCode.isPresent()) {
            KeyEvent event = new KeyEvent(keyEvent.getSource(), null, KeyEvent.KEY_PRESSED, "", "", keyCode.get(), keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), keyEvent.isMetaDown());
            return this.mapToKeyBinding(event);
        }
        return Optional.empty();
    }

    public KeyStroke getKey(KeyBinding bindName) {
        String s2 = this.get(bindName.getConstant());
        s2 = s2.replace("+", " ");
        if (OS.OS_X) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(s2));
        }
        return KeyStroke.getKeyStroke(s2);
    }

    public KeyCombination getKeyCombination(KeyBinding bindName) {
        String binding = this.get(bindName.getConstant());
        if (OS.OS_X) {
            binding = binding.replace("ctrl", "meta");
        }
        return KeyCombination.valueOf((String)binding);
    }

    public boolean checkKeyCombinationEquality(KeyBinding binding, KeyEvent keyEvent) {
        KeyCombination keyCombination = this.getKeyCombination(binding);
        return KeyBindingRepository.checkKeyCombinationEquality(keyCombination, keyEvent);
    }

    private KeyStroke getKeyForMac(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        int keyCode = ks.getKeyCode();
        if ((ks.getModifiers() & 2) == 0) {
            return ks;
        }
        int modifiers = 0;
        if ((ks.getModifiers() & 1) != 0) {
            modifiers |= 1;
        }
        if ((ks.getModifiers() & 8) != 0) {
            modifiers |= 8;
        }
        if (this.shortcutMask == -1) {
            try {
                this.shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (AWTError | HeadlessException e) {
                LOGGER.warn("Problem geting shortcut mask", e);
            }
        }
        return KeyStroke.getKeyStroke(keyCode, this.shortcutMask + modifiers);
    }

    public List<String> getBindNames() {
        return this.bindings.keySet().stream().map(KeyBinding::getConstant).collect(Collectors.toList());
    }

    public List<String> getBindings() {
        return new ArrayList<String>(this.bindings.values());
    }
}

