/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import com.google.common.base.CaseFormat;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingCategory;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class KeyBindingViewModel {
    private KeyBinding keyBinding = null;
    private String realBinding = "";
    private final ObservableList<KeyBindingViewModel> children = FXCollections.observableArrayList();
    private final KeyBindingRepository keyBindingRepository;
    private final SimpleStringProperty displayName = new SimpleStringProperty();
    private final SimpleStringProperty shownBinding = new SimpleStringProperty();
    private final KeyBindingCategory category;

    public KeyBindingViewModel(KeyBindingRepository keyBindingRepository, KeyBinding keyBinding, String binding) {
        this(keyBindingRepository, keyBinding.getCategory());
        this.keyBinding = keyBinding;
        this.setDisplayName();
        this.setBinding(binding);
    }

    public KeyBindingViewModel(KeyBindingRepository keyBindingRepository, KeyBindingCategory category) {
        this.keyBindingRepository = keyBindingRepository;
        this.category = category;
        this.setDisplayName();
    }

    public ObservableList<KeyBindingViewModel> getChildren() {
        return this.children;
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    public StringProperty shownBindingProperty() {
        return this.shownBinding;
    }

    public String getBinding() {
        return this.realBinding;
    }

    private void setBinding(String bind) {
        this.realBinding = bind;
        String[] parts = bind.split(" ");
        String displayBind = "";
        for (String part : parts) {
            displayBind = displayBind + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, part) + " ";
        }
        this.shownBinding.set(displayBind.trim().replace(" ", " + "));
    }

    private void setDisplayName() {
        this.displayName.set(this.keyBinding == null ? this.category.getName() : this.keyBinding.getLocalization());
    }

    public StringProperty nameProperty() {
        return this.displayName;
    }

    public boolean isCategory() {
        return this.keyBinding == null;
    }

    public boolean setNewBinding(KeyEvent evt) {
        KeyCode code = evt.getCode();
        if (code.isModifierKey() || code == KeyCode.BACK_SPACE || code == KeyCode.SPACE || code == KeyCode.TAB || code == KeyCode.ENTER || code == KeyCode.UNDEFINED) {
            return false;
        }
        String modifiers = "";
        if (evt.isControlDown()) {
            modifiers = "ctrl+";
        }
        if (evt.isShiftDown()) {
            modifiers = modifiers + "shift+";
        }
        if (evt.isAltDown()) {
            modifiers = modifiers + "alt+";
        }
        if (modifiers.isEmpty() && !code.isFunctionKey() && code != KeyCode.ESCAPE && code != KeyCode.DELETE) {
            return false;
        }
        String newShortcut = modifiers + code;
        this.setBinding(newShortcut);
        return true;
    }

    public void resetToDefault() {
        if (!this.isCategory()) {
            String key = this.getKeyBinding().getConstant();
            this.keyBindingRepository.resetToDefault(key);
            this.setBinding(this.keyBindingRepository.get(key));
        }
    }

    public Optional<IconTheme.JabRefIcon> getIcon() {
        return this.isCategory() ? Optional.empty() : Optional.of(IconTheme.JabRefIcon.CLEANUP_ENTRIES);
    }
}

