/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.plaintextimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.StyledDocument;

public class TagToMarkedTextStore {
    private final Map<String, List<TMarkedStoreItem>> tagMap = new HashMap<String, List<TMarkedStoreItem>>();

    public void appendPosition(String tag, int start, int end) {
        List<TMarkedStoreItem> ll = this.tagMap.get(tag);
        if (ll == null) {
            ll = new ArrayList<TMarkedStoreItem>();
            this.tagMap.put(tag, ll);
        }
        ll.add(new TMarkedStoreItem(start, end));
    }

    public void insertPosition(String tag, int start, int end) {
        List<TMarkedStoreItem> ll = this.tagMap.get(tag);
        if (ll == null) {
            ll = new ArrayList<TMarkedStoreItem>();
            this.tagMap.put(tag, ll);
        } else {
            ll.clear();
        }
        ll.add(new TMarkedStoreItem(start, end));
    }

    public void setStyleForTag(String tag, String style, StyledDocument doc) {
        List<TMarkedStoreItem> ll = this.tagMap.get(tag);
        if (ll != null) {
            for (TMarkedStoreItem item : ll) {
                if (item == null) continue;
                doc.setCharacterAttributes(item.getStart(), item.getLength(), doc.getStyle(style), true);
            }
        }
    }

    private static class TMarkedStoreItem {
        private final int start;
        private final int end;

        public TMarkedStoreItem(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.end - this.start;
        }
    }
}

