/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.jabref.model.strings.StringUtil;

public class ViewModelTreeTableCellFactory<S, T>
implements Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>> {
    private Callback<S, String> toText;
    private Callback<S, Node> toGraphic;
    private Callback<S, EventHandler<? super MouseEvent>> toOnMouseClickedEvent;
    private Callback<S, String> toTooltip;

    public ViewModelTreeTableCellFactory<S, T> withText(Callback<S, String> toText) {
        this.toText = toText;
        return this;
    }

    public ViewModelTreeTableCellFactory<S, T> withGraphic(Callback<S, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ViewModelTreeTableCellFactory<S, T> withIcon(Callback<S, MaterialDesignIcon> toIcon, Callback<S, Paint> toColor) {
        this.toGraphic = viewModel -> {
            Text graphic = MaterialDesignIconFactory.get().createIcon((GlyphIcons)toIcon.call(viewModel));
            graphic.setFill((Paint)toColor.call(viewModel));
            return graphic;
        };
        return this;
    }

    public ViewModelTreeTableCellFactory<S, T> withTooltip(Callback<S, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ViewModelTreeTableCellFactory<S, T> withOnMouseClickedEvent(Callback<S, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public TreeTableCell<S, T> call(TreeTableColumn<S, T> param2) {
        return new TreeTableCell<S, T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || this.getTreeTableRow() == null || this.getTreeTableRow().getItem() == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                } else {
                    String tooltip;
                    Object viewModel = this.getTreeTableRow().getItem();
                    if (ViewModelTreeTableCellFactory.this.toText != null) {
                        this.setText((String)ViewModelTreeTableCellFactory.this.toText.call(viewModel));
                    }
                    if (ViewModelTreeTableCellFactory.this.toGraphic != null) {
                        this.setGraphic((Node)ViewModelTreeTableCellFactory.this.toGraphic.call(viewModel));
                    }
                    if (ViewModelTreeTableCellFactory.this.toTooltip != null && StringUtil.isNotBlank(tooltip = (String)ViewModelTreeTableCellFactory.this.toTooltip.call(viewModel))) {
                        this.setTooltip(new Tooltip(tooltip));
                    }
                    if (ViewModelTreeTableCellFactory.this.toOnMouseClickedEvent != null) {
                        this.setOnMouseClicked((EventHandler)ViewModelTreeTableCellFactory.this.toOnMouseClickedEvent.call(viewModel));
                    }
                }
            }
        };
    }
}

