/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.formatter.casechanger.TitleParser;
import org.jabref.logic.formatter.casechanger.Word;

public final class Title {
    private final List<Word> words = new LinkedList<Word>();

    public Title(String title) {
        this.words.addAll(new TitleParser().parse(title));
    }

    public List<Word> getWords() {
        return Collections.unmodifiableList(this.words);
    }

    public Optional<Word> getFirstWord() {
        if (this.getWords().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getWords().get(0));
    }

    public Optional<Word> getLastWord() {
        if (this.getWords().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getWords().get(this.getWords().size() - 1));
    }

    public String toString() {
        return this.words.stream().map(Word::toString).collect(Collectors.joining(" "));
    }
}

