/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Optional;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONEntryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONEntryParser.class);

    public BibEntry parseBibJSONtoBibtex(JSONObject bibJsonEntry, Character keywordSeparator) {
        String[] singleFieldStrings = new String[]{"year", "title", "abstract", "month"};
        String[] journalSingleFieldStrings = new String[]{"publisher", "number", "volume"};
        BibEntry entry = new BibEntry();
        entry.setType("article");
        if (bibJsonEntry.has("author")) {
            String[] authors = bibJsonEntry.getJSONArray("author");
            ArrayList<String> authorList = new ArrayList<String>();
            for (int i = 0; i < authors.length(); ++i) {
                if (authors.getJSONObject(i).has("name")) {
                    authorList.add(authors.getJSONObject(i).getString("name"));
                    continue;
                }
                LOGGER.info("Empty author name.");
            }
            entry.setField("author", String.join((CharSequence)" and ", authorList));
        } else {
            LOGGER.info("No author found.");
        }
        for (String field2 : singleFieldStrings) {
            if (!bibJsonEntry.has(field2)) continue;
            entry.setField(field2, bibJsonEntry.getString(field2));
        }
        if (bibJsonEntry.has("start_page")) {
            if (bibJsonEntry.has("end_page")) {
                entry.setField("pages", bibJsonEntry.getString("start_page") + "--" + bibJsonEntry.getString("end_page"));
            } else {
                entry.setField("pages", bibJsonEntry.getString("start_page"));
            }
        }
        if (bibJsonEntry.has("journal")) {
            JSONObject journal = bibJsonEntry.getJSONObject("journal");
            if (journal.has("title")) {
                entry.setField("journal", journal.getString("title"));
            } else {
                LOGGER.info("No journal title found.");
            }
            for (String field3 : journalSingleFieldStrings) {
                if (!journal.has(field3)) continue;
                entry.setField(field3, journal.getString(field3));
            }
        } else {
            LOGGER.info("No journal information found.");
        }
        if (bibJsonEntry.has("keywords")) {
            JSONArray keywords = bibJsonEntry.getJSONArray("keywords");
            for (int i = 0; i < keywords.length(); ++i) {
                if (keywords.isNull(i)) continue;
                entry.addKeyword(keywords.getString(i), keywordSeparator);
            }
        }
        if (bibJsonEntry.has("identifier")) {
            JSONArray identifiers = bibJsonEntry.getJSONArray("identifier");
            for (int i = 0; i < identifiers.length(); ++i) {
                String type = identifiers.getJSONObject(i).getString("type");
                if ("doi".equals(type)) {
                    entry.setField("doi", identifiers.getJSONObject(i).getString("id"));
                    continue;
                }
                if ("pissn".equals(type)) {
                    entry.setField("issn", identifiers.getJSONObject(i).getString("id"));
                    continue;
                }
                if (!"eissn".equals(type)) continue;
                entry.setField("issn", identifiers.getJSONObject(i).getString("id"));
            }
        }
        if (bibJsonEntry.has("link")) {
            JSONArray links = bibJsonEntry.getJSONArray("link");
            for (int i = 0; i < links.length(); ++i) {
                String type;
                if (!links.getJSONObject(i).has("type") || !"fulltext".equals(type = links.getJSONObject(i).getString("type")) || !links.getJSONObject(i).has("url")) continue;
                entry.setField("url", links.getJSONObject(i).getString("url"));
            }
        }
        return entry;
    }

    public static BibEntry parseSpringerJSONtoBibtex(JSONObject springerJsonEntry) {
        String nametype;
        String[] singleFieldStrings = new String[]{"issn", "volume", "abstract", "doi", "title", "number", "publisher"};
        BibEntry entry = new BibEntry();
        String isbn = springerJsonEntry.optString("isbn");
        if (Strings.isNullOrEmpty(isbn)) {
            entry.setType("article");
            nametype = "journal";
        } else {
            entry.setType("incollection");
            nametype = "booktitle";
            entry.setField("isbn", isbn);
        }
        if (springerJsonEntry.has("creators")) {
            String[] authors = springerJsonEntry.getJSONArray("creators");
            ArrayList<String> authorList = new ArrayList<String>();
            for (int i = 0; i < authors.length(); ++i) {
                if (authors.getJSONObject(i).has("creator")) {
                    authorList.add(authors.getJSONObject(i).getString("creator"));
                    continue;
                }
                LOGGER.info("Empty author name.");
            }
            entry.setField("author", String.join((CharSequence)" and ", authorList));
        } else {
            LOGGER.info("No author found.");
        }
        for (String field2 : singleFieldStrings) {
            String text;
            if (!springerJsonEntry.has(field2) || (text = springerJsonEntry.getString(field2)).isEmpty()) continue;
            entry.setField(field2, text);
        }
        if (springerJsonEntry.has("startingPage") && !springerJsonEntry.getString("startingPage").isEmpty()) {
            if (springerJsonEntry.has("endPage") && !springerJsonEntry.getString("endPage").isEmpty()) {
                entry.setField("pages", springerJsonEntry.getString("startingPage") + "--" + springerJsonEntry.getString("endPage"));
            } else {
                entry.setField("pages", springerJsonEntry.getString("startingPage"));
            }
        }
        if (springerJsonEntry.has("publicationName")) {
            entry.setField(nametype, springerJsonEntry.getString("publicationName"));
        }
        if (springerJsonEntry.has("url")) {
            JSONArray urlarray = springerJsonEntry.optJSONArray("url");
            if (urlarray == null) {
                entry.setField("url", springerJsonEntry.optString("url"));
            } else {
                entry.setField("url", urlarray.getJSONObject(0).optString("value"));
            }
        }
        if (springerJsonEntry.has("publicationDate")) {
            String date = springerJsonEntry.getString("publicationDate");
            entry.setField("date", date);
            String[] dateparts = date.split("-");
            entry.setField("year", dateparts[0]);
            Optional<Month> month = Month.getMonthByNumber(Integer.parseInt(dateparts[1]));
            month.ifPresent(entry::setMonth);
        }
        entry.getField("abstract").ifPresent(abstractContents -> {
            if (abstractContents.startsWith("Abstract")) {
                entry.setField("abstract", abstractContents.substring(8));
            }
        });
        return entry;
    }
}

