/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class JournalInAbbreviationListChecker
implements IntegrityCheck.Checker {
    private final String field;
    private final JournalAbbreviationRepository abbreviationRepository;

    public JournalInAbbreviationListChecker(String field2, JournalAbbreviationRepository abbreviationRepository) {
        this.field = Objects.requireNonNull(field2);
        this.abbreviationRepository = Objects.requireNonNull(abbreviationRepository);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField(this.field);
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        String journal = value.get();
        if (!this.abbreviationRepository.isKnownName(journal)) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("journal not found in abbreviation list", new String[0]), entry, this.field));
        }
        return Collections.emptyList();
    }
}

