/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.jspecify.annotations.Nullable;

public class UpToDateResult
extends AfterExecutionResult {
    private final ImmutableList<String> executionReasons;
    private final OriginMetadata reusedOutputOriginMetadata;

    public UpToDateResult(AfterExecutionResult parent, ImmutableList<String> executionReasons) {
        super(parent);
        this.executionReasons = executionReasons;
        this.reusedOutputOriginMetadata = parent.getAfterExecutionOutputState().filter(ExecutionOutputState::isReused).map(ExecutionOutputState::getOriginMetadata).orElse(null);
    }

    public UpToDateResult(Duration duration, Try<ExecutionEngine.Execution> execution, @Nullable ExecutionOutputState executionOutputState, ImmutableList<String> executionReasons, @Nullable OriginMetadata reusedOutputOriginMetadata) {
        super(duration, execution, executionOutputState);
        this.executionReasons = executionReasons;
        this.reusedOutputOriginMetadata = reusedOutputOriginMetadata;
    }

    protected UpToDateResult(UpToDateResult parent) {
        super(parent);
        this.executionReasons = parent.getExecutionReasons();
        this.reusedOutputOriginMetadata = parent.getReusedOutputOriginMetadata().orElse(null);
    }

    public ImmutableList<String> getExecutionReasons() {
        return this.executionReasons;
    }

    public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
        return Optional.ofNullable(this.reusedOutputOriginMetadata);
    }
}

