/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.coverage.CoverageNameMapper;
import com.google.jstestdriver.coverage.CoverageWriter;
import java.io.IOException;
import java.io.Writer;

public class LcovWriter
implements CoverageWriter {
    private final Writer out;
    private final CoverageNameMapper mapper;

    @Inject
    public LcovWriter(@Named(value="coverageFileWriter") Writer out, CoverageNameMapper mapper) {
        this.out = out;
        this.mapper = mapper;
    }

    public void writeRecordStart(Integer fileId) {
        try {
            this.out.append("SF:").append(this.mapper.unmap(fileId)).append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeRecordEnd() {
        try {
            this.out.append("end_of_record\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCoverage(int lineNumber, int executedNumber) {
        try {
            this.out.append("DA:").append(String.valueOf(lineNumber)).append(",").append(String.valueOf(executedNumber)).append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

