/* stsMapMouseNew.h was originally generated by the autoSql program, which also 
 * generated stsMapMouseNew.c and stsMapMouseNew.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef STSMAPMOUSENEW_H
#define STSMAPMOUSENEW_H

#define STSMAPMOUSENEW_NUM_COLS 15

struct stsMapMouseNew
/* STS marker and its position on golden path and various maps */
    {
    struct stsMapMouseNew *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of STS marker */
    unsigned score;     /* Score of a marker = 1000/(#placements) when placed uniquely, else 1500/(#placements) when placed in multiple locations */
    unsigned identNo;	/* Identification number of STS */
    char *ctgAcc;	/* Contig accession number */
    char *otherAcc;	/* Accession number of other contigs that the marker hits */
    char *rhChrom;	/* Chromosome (no chr) from RH map or 0 if none */
    float rhPos;	/* Position on rh map */
    float rhLod;	/* Lod score of RH map */
    char *wigChr;	/* Chromosome (no chr) from FHHxACI genetic or 0 if none */
    float wigPos;	/* Position on FHHxACI map */
    char *mgiChrom;	/* Chromosome (no chr) from SHRSPxBN geneticmap or 0 if none */
    float mgiPos;	/* Position on SHRSPxBN genetic map */
    };

void stsMapMouseNewStaticLoad(char **row, struct stsMapMouseNew *ret);
/* Load a row from stsMapMouseNew table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct stsMapMouseNew *stsMapMouseNewLoad(char **row);
/* Load a stsMapMouseNew from row fetched with select * from stsMapMouseNew
 * from database.  Dispose of this with stsMapMouseNewFree(). */

struct stsMapMouseNew *stsMapMouseNewLoadAll(char *fileName);
/* Load all stsMapMouseNew from whitespace-separated file.
 * Dispose of this with stsMapMouseNewFreeList(). */

struct stsMapMouseNew *stsMapMouseNewLoadAllByChar(char *fileName, char chopper);
/* Load all stsMapMouseNew from chopper separated file.
 * Dispose of this with stsMapMouseNewFreeList(). */

#define stsMapMouseNewLoadAllByTab(a) stsMapMouseNewLoadAllByChar(a, '\t');
/* Load all stsMapMouseNew from tab separated file.
 * Dispose of this with stsMapMouseNewFreeList(). */

struct stsMapMouseNew *stsMapMouseNewCommaIn(char **pS, struct stsMapMouseNew *ret);
/* Create a stsMapMouseNew out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsMapMouseNew */

void stsMapMouseNewFree(struct stsMapMouseNew **pEl);
/* Free a single dynamically allocated stsMapMouseNew such as created
 * with stsMapMouseNewLoad(). */

void stsMapMouseNewFreeList(struct stsMapMouseNew **pList);
/* Free a list of dynamically allocated stsMapMouseNew's */

void stsMapMouseNewOutput(struct stsMapMouseNew *el, FILE *f, char sep, char lastSep);
/* Print out stsMapMouseNew.  Separate fields with sep. Follow last field with lastSep. */

#define stsMapMouseNewTabOut(el,f) stsMapMouseNewOutput(el,f,'\t','\n');
/* Print out stsMapMouseNew as a line in a tab-separated file. */

#define stsMapMouseNewCommaOut(el,f) stsMapMouseNewOutput(el,f,',',',');
/* Print out stsMapMouseNew as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* STSMAPMOUSENEW_H */

