/* transMapInfo.h was originally generated by the autoSql program, which also 
 * generated transMapInfo.c and transMapInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef TRANSMAPINFO_H
#define TRANSMAPINFO_H

#define TRANSMAPINFO_NUM_COLS 5

enum transMapInfoChainSubset
    {
    transMapInfoUnknown = 0,
    transMapInfoAll = 1,
    transMapInfoSyn = 2,
    transMapInfoRbest = 3,
    };
struct transMapInfo
/* genomeDB information about transMap alignments */
    {
    struct transMapInfo *next;  /* Next in singly linked list. */
    char *mappedId;	/* id of mapped alignment */
    char srcDb[17];	/* source db */
    char *srcId;	/* id of source alignment */
    char *mappingId;	/* id of chain used for mapping */
    enum transMapInfoChainSubset chainSubset;	/* chain subset used */
    };

void transMapInfoStaticLoad(char **row, struct transMapInfo *ret);
/* Load a row from transMapInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct transMapInfo *transMapInfoLoad(char **row);
/* Load a transMapInfo from row fetched with select * from transMapInfo
 * from database.  Dispose of this with transMapInfoFree(). */

struct transMapInfo *transMapInfoLoadAll(char *fileName);
/* Load all transMapInfo from whitespace-separated file.
 * Dispose of this with transMapInfoFreeList(). */

struct transMapInfo *transMapInfoLoadAllByChar(char *fileName, char chopper);
/* Load all transMapInfo from chopper separated file.
 * Dispose of this with transMapInfoFreeList(). */

#define transMapInfoLoadAllByTab(a) transMapInfoLoadAllByChar(a, '\t');
/* Load all transMapInfo from tab separated file.
 * Dispose of this with transMapInfoFreeList(). */

struct transMapInfo *transMapInfoCommaIn(char **pS, struct transMapInfo *ret);
/* Create a transMapInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new transMapInfo */

void transMapInfoFree(struct transMapInfo **pEl);
/* Free a single dynamically allocated transMapInfo such as created
 * with transMapInfoLoad(). */

void transMapInfoFreeList(struct transMapInfo **pList);
/* Free a list of dynamically allocated transMapInfo's */

void transMapInfoOutput(struct transMapInfo *el, FILE *f, char sep, char lastSep);
/* Print out transMapInfo.  Separate fields with sep. Follow last field with lastSep. */

#define transMapInfoTabOut(el,f) transMapInfoOutput(el,f,'\t','\n');
/* Print out transMapInfo as a line in a tab-separated file. */

#define transMapInfoCommaOut(el,f) transMapInfoOutput(el,f,',',',');
/* Print out transMapInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct sqlConnection;
struct transMapInfo *transMapInfoQuery(struct sqlConnection *conn,
                                       char *table, char *mappedId);
/* load a single transMapInfo object for an mapped id from a table,
 * or error if not found */

#endif /* TRANSMAPINFO_H */

