/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;

public class BlockCipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher cipher;
    private int lastOutputSize = -1;

    public BlockCipherOutputStream(OutputStream out, BufferedBlockCipher cipher) {
        super(out);
        this.cipher = cipher;
    }

    public void close() throws IOException {
        try {
            byte[] buf;
            int num;
            if (this.lastOutputSize >= 0 && (num = this.cipher.doFinal(buf = new byte[this.lastOutputSize], 0)) > 0) {
                this.out.write(buf, 0, num);
            }
            this.out.flush();
            this.out.close();
            this.lastOutputSize = -1;
        }
        catch (Exception cause) {
            IOException ioex = new IOException(String.valueOf(cause));
            ioex.initCause(cause);
            throw ioex;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] b, int off, int le) throws IOException {
        this.lastOutputSize = this.cipher.getOutputSize(le);
        byte[] buf = new byte[this.lastOutputSize];
        int num = this.cipher.processBytes(b, off, le, buf, 0);
        if (num > 0) {
            this.out.write(buf, 0, num);
        }
    }
}

