/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapElementTransfer
extends ByteArrayTransfer {
    private static final MindMapElementTransfer instance = new MindMapElementTransfer();
    private static final String TYPE_NAME = "mindmap-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPE_ID = MindMapElementTransfer.registerType((String)TYPE_NAME);
    private Object[] elements = null;
    private IWorkbook tempWorkbook = null;
    private Map<Object, Object> cloneMap = new HashMap<Object, Object>();

    protected MindMapElementTransfer() {
    }

    public static MindMapElementTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof Object[])) {
            this.setElements(null);
            return;
        }
        this.setElements((Object[])object);
        if (this.getElements() == null) {
            return;
        }
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object object = super.nativeToJava(transferData);
        return object == null ? null : this.elements;
    }

    boolean checkType(Object object) {
        if (!(object instanceof Object[])) {
            return false;
        }
        Object[] eles = (Object[])object;
        return eles.length > 0;
    }

    protected boolean validate(Object object) {
        return this.checkType(object);
    }

    public void setElements(Object[] elements) {
        this.elements = this.recreateElements(elements);
    }

    public Object[] getElements() {
        return this.elements;
    }

    private Object[] recreateElements(Object[] elements) {
        this.tempWorkbook = this.recreateTempWorkbook();
        if (elements == null || elements.length == 0) {
            return null;
        }
        ICloneData result = this.tempWorkbook.clone(Arrays.asList(elements));
        Collection cloneds = result.getCloneds();
        if (!cloneds.isEmpty()) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IMarkerRef) {
                    IMarkerRef ref = (IMarkerRef)element;
                    ((MarkerSheetImpl)this.tempWorkbook.getMarkerSheet()).getElementRegistry().register((IIdentifiable)ref.getMarker());
                }
                ++n2;
            }
            this.fillCloneMap(result, elements);
            return cloneds.toArray();
        }
        return null;
    }

    private void fillCloneMap(ICloneData result, Object[] elements) {
        if (!this.cloneMap.isEmpty()) {
            this.cloneMap.clear();
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Object cloned = result.get(obj);
            this.cloneMap.put(cloned, obj);
            ++n2;
        }
    }

    public Map<Object, Object> getTransferMap() {
        return this.cloneMap;
    }

    private IWorkbook recreateTempWorkbook() {
        String tempDir = Core.getWorkspace().getTempDir("element_transfer.xmind.temp");
        File tempLocation = new File(tempDir);
        FileUtils.delete((File)tempLocation);
        tempLocation.mkdirs();
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook((IStorage)new DirectoryStorage(tempLocation));
        workbook.getMarkerSheet().setParentSheet(MindMapUI.getResourceManager().getSystemMarkerSheet());
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setWorkbookStorageAsOutputTarget();
            serializer.serialize(null);
        }
        catch (Exception exception) {}
        return workbook;
    }
}

