/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.util.ImageFormat;

public class TemplateLabelProvider
extends LabelProvider
implements ISchedulingRule {
    private static final String CACHES_TEMPLATES_DIR = "caches/templates/";
    private static ImageFormat defaultFormat = ImageFormat.PNG;
    private Map<ITemplate, TemplateThumbnailImageLoader> imageLoaders = new HashMap<ITemplate, TemplateThumbnailImageLoader>();
    private Properties cachedImagePathMap = null;

    public boolean contains(ISchedulingRule rule) {
        return rule instanceof TemplateLabelProvider;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule instanceof TemplateLabelProvider;
    }

    public Image getImage(Object element) {
        if (!(element instanceof ITemplate)) {
            return super.getImage(element);
        }
        ITemplate template = (ITemplate)element;
        TemplateThumbnailImageLoader loader = this.imageLoaders.get(element);
        if (loader == null) {
            loader = new TemplateThumbnailImageLoader(this, template, Display.getCurrent());
            this.imageLoaders.put(template, loader);
        }
        return loader.getImage();
    }

    public void dispose() {
        super.dispose();
        Object[] loaderArray = this.imageLoaders.values().toArray();
        this.imageLoaders.clear();
        Object[] objectArray = loaderArray;
        int n = loaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object loader = objectArray[n2];
            ((TemplateThumbnailImageLoader)loader).dispose();
            ++n2;
        }
    }

    private Properties getImagePathMap() {
        if (this.cachedImagePathMap == null) {
            Properties map = new Properties();
            File mapFile = TemplateLabelProvider.getImagePathMapFile();
            if (mapFile.isFile() && mapFile.canRead()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(mapFile));
                    try {
                        map.load(reader);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable e) {
                    MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to load cached template thumbnail image path map from file: " + mapFile, e));
                }
            }
            this.cachedImagePathMap = map;
        }
        return this.cachedImagePathMap;
    }

    private void saveImagePathMap() {
        Properties map = this.cachedImagePathMap;
        if (map == null) {
            return;
        }
        File mapFile = TemplateLabelProvider.getImagePathMapFile();
        FileUtils.ensureFileParent((File)mapFile);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(mapFile));
            try {
                map.store(writer, null);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Throwable e) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to save cached template thumbnail image path map to file: " + mapFile, e));
        }
    }

    private static File getImagePathMapFile() {
        return new File(TemplateLabelProvider.getCacheDirForTemplates(), "images.map");
    }

    private static File getCacheDirForTemplates() {
        return MindMapUIPlugin.getDefault().getStateLocation().append(CACHES_TEMPLATES_DIR).toFile();
    }

    public String getText(Object element) {
        if (element instanceof ITemplate) {
            ITemplate template = (ITemplate)element;
            return template.getName();
        }
        return super.getText(element);
    }

    static /* synthetic */ Properties access$0(TemplateLabelProvider templateLabelProvider) {
        return templateLabelProvider.getImagePathMap();
    }

    static /* synthetic */ File access$1() {
        return TemplateLabelProvider.getCacheDirForTemplates();
    }

    private static class TemplateThumbnailImageLoader {
        private final TemplateLabelProvider owner;
        private final ITemplate template;
        private final Display display;
        private Image image;
        private boolean disposed;

        public TemplateThumbnailImageLoader(TemplateLabelProvider owner, ITemplate template, Display display) {
            this.owner = owner;
            this.template = template;
            this.display = display;
            this.image = null;
            this.disposed = false;
            Job initJob = Job.create((String)NLS.bind((String)MindMapMessages.TemplateLabelProvider_loadThumbnail_jobName, (Object)template.getName()), (IJobFunction)new IJobFunction(){

                public IStatus run(IProgressMonitor monitor) {
                    return TemplateThumbnailImageLoader.this.doLoad(monitor);
                }
            });
            initJob.setSystem(true);
            initJob.setRule((ISchedulingRule)owner);
            MindMapUIPlugin.getDefault().registerJob(initJob);
            initJob.schedule();
        }

        /*
         * Exception decompiling
         */
        private IStatus doLoad(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File extractThumbnailImageFromLocalFile(File sourceWorkbookFile, File cachedImageFile) {
            String thumbnailArchivePath = MindMapImageExporter.toThumbnailArchivePath(defaultFormat);
            if (sourceWorkbookFile.isDirectory()) {
                File sourceThumbnailFile = new File(sourceWorkbookFile, thumbnailArchivePath);
                if (!sourceThumbnailFile.isFile()) return null;
                if (!sourceThumbnailFile.canRead()) return null;
                return sourceThumbnailFile;
            }
            if (!sourceWorkbookFile.isFile()) return null;
            if (!sourceWorkbookFile.canRead()) {
                return null;
            }
            try {
                ZipInputStream sourceInput = new ZipInputStream(new FileInputStream(sourceWorkbookFile));
                try {
                    ZipEntry entry;
                    while ((entry = sourceInput.getNextEntry()) != null && !thumbnailArchivePath.equals(entry.getName())) {
                    }
                    if (entry == null) {
                        return null;
                    }
                    FileUtils.ensureFileParent((File)cachedImageFile);
                    FileOutputStream imageOutput = new FileOutputStream(cachedImageFile);
                    try {
                        byte[] buffer = new byte[2048];
                        while (true) {
                            int numInBuffer;
                            if ((numInBuffer = sourceInput.read(buffer)) <= 0) {
                                return cachedImageFile;
                            }
                            ((OutputStream)imageOutput).write(buffer, 0, numInBuffer);
                        }
                    }
                    finally {
                        ((OutputStream)imageOutput).close();
                    }
                }
                finally {
                    sourceInput.close();
                }
            }
            catch (Throwable e) {
                MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to extract thumbnail image from source workbook file: " + sourceWorkbookFile, e));
                return null;
            }
        }

        private IStatus doGenerate(IProgressMonitor monitor, IWorkbook workbook, File targetImageFile, String targetImagePath, URI sourceWorkbookURI, Properties imagePathMap) {
            if (this.isDisposed() || this.display.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            MindMapImageExporter exporter = new MindMapImageExporter(this.display);
            exporter.setSource(new MindMap(workbook.getPrimarySheet()), null, new Insets(15));
            exporter.setResize(4, 800, 600);
            exporter.setTargetFile(targetImageFile);
            exporter.export();
            if (targetImageFile.isFile() && targetImageFile.canRead()) {
                imagePathMap.put(sourceWorkbookURI.toString(), targetImagePath);
                this.owner.saveImagePathMap();
                return this.loadImage(targetImageFile);
            }
            return new Status(4, "org.xmind.ui.mindmap", "Failed to generate thumbnail image for template: " + sourceWorkbookURI.toString());
        }

        private IStatus loadImage(File imageFile) {
            if (this.isDisposed() || this.display.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            final Image image = new Image((Device)this.display, imageFile.getAbsolutePath());
            if (this.isDisposed() || this.display.isDisposed()) {
                image.dispose();
                return Status.CANCEL_STATUS;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TemplateThumbnailImageLoader.this.isDisposed()) {
                        image.dispose();
                        return;
                    }
                    TemplateThumbnailImageLoader.this.setImage(image);
                }
            });
            return Status.OK_STATUS;
        }

        private void setImage(Image image) {
            Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Not in UI thread");
            this.image = image;
            if (!this.isDisposed()) {
                this.owner.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this.owner, (Object)this.template));
            }
        }

        public void dispose() {
            Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Not in UI thread");
            this.disposed = true;
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }

        public Image getImage() {
            Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Not in UI thread");
            return this.image;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

