/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.cathy.internal.CathyPlugin;

public class OpenDocumentQueue {
    private static final String[] EMPTY_QUEUE = new String[0];
    private static final OpenDocumentQueue instance = new OpenDocumentQueue();
    private List<String> files = new ArrayList<String>();
    private Listener hook = null;

    private OpenDocumentQueue() {
    }

    public void hook(Display display) {
        if (this.hook == null) {
            this.hook = new OpenDocumentHook();
        }
        display.addListener(46, this.hook);
    }

    public void unhook(Display display) {
        if (this.hook != null) {
            display.removeListener(46, this.hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(String path) {
        if (new File(path).exists()) {
            OpenDocumentQueue openDocumentQueue = this;
            synchronized (openDocumentQueue) {
                this.files.add(path);
            }
            CathyPlugin.log("Path queued to be opened: " + path);
        } else {
            CathyPlugin.log("Non-existing path skipped: " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] drain() {
        OpenDocumentQueue openDocumentQueue = this;
        synchronized (openDocumentQueue) {
            if (this.files.isEmpty()) {
                return EMPTY_QUEUE;
            }
            String[] array = this.files.toArray(new String[this.files.size()]);
            this.files.clear();
            return array;
        }
    }

    public static OpenDocumentQueue getInstance() {
        return instance;
    }

    private class OpenDocumentHook
    implements Listener {
        private OpenDocumentHook() {
        }

        public void handleEvent(Event event) {
            if (event.text != null && !"".equals(event.text)) {
                OpenDocumentQueue.this.enqueue(event.text);
            }
        }
    }
}

