/*******************************************************************************
 * The information contained in this file is confidential and proprietary to
 * QLogic Corporation.  No part of this file may be reproduced or
 * distributed, in any form or by any means for any purpose, without the
 * express written permission of QLogic Corporation.
 *
 * (c) COPYRIGHT 2015 QLogic Corporation, ALL RIGHTS RESERVED.
 *******************************************************************************/
/* **********************************************************
  * Copyright 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
  * **********************************************************/

/*
 * qfle3_sm.h --
 *
 *      Header file for native qfle3 driver Statemachine .
 */

#ifndef _QFLE3_SM_H_
#define _QFLE3_SM_H_

/* adapter states */
#define     QFLE3_SM_NOTREADY       0x0000
#define     QFLE3_SM_STANDBY        0x0001
#define     QFLE3_SM_HWREADY        0x0002
//#define     QFLE3_SM_DEVREADY       0x0003
//#define     QFLE3_SM_PORTREADY      0x0004
//#define     QFLE3_SM_FUNCREADY      0x0005
#define     QFLE3_SM_ACTIVATED      0x0006
#define     QFLE3_SM_IOSTARTED      0x0007
#define     QFLE3_SM_MAXSTATE       0x0008

/* queue states */
#define     QFLE3_SM_Q_CREATED      0x00000001
#define     QFLE3_SM_Q_STARTED      0x00000002


#define     QFLE3_SM_PARAM_RXQ      0x0001
#define     QFLE3_SM_PARAM_TXQ      0x0002
#define     QFLE3_SM_PARAM_DRV      0x0004
#define     QFLE3_SM_PARAM_HW       0x0008




/* statemachine commands */
#define     QFLE3_SMCMD_UNKNOWN        0x0000
#define     QFLE3_SMCMD_BRINGUP        0x0001   // Take the hardware from HWREADY state to FUNCREADY
//#define     QFLE3_SMCMD_FUNCRESET      0x0002   // Reload the physical function
#define     QFLE3_SMCMD_START          0x0003   // Start the Uplink
#define     QFLE3_SMCMD_PAUSEIO        0x0004   // Pause Tx and Rx queue, stop traffic
#define     QFLE3_SMCMD_RESUMEIO       0x0005   // Resume Tx and Rx traffic
#define     QFLE3_SMCMD_STOP           0x0006   // Stop the Uplink
#define     QFLE3_SMCMD_TOSTANDBY      0x0007   // Take this adapter out of commission
#define     QFLE3_SMCMD_UPLINKRESET    0x0008   // Stop the uplink and restart again
#define     QFLE3_SMCMD_CREATE_Q       0x0009   // Create a Q
#define     QFLE3_SMCMD_START_Q        0x000a
#define     QFLE3_SMCMD_REMOVE_Q       0x000c
#define     QFLE3_SMCMD_STOP_Q         0x000d

#define     QFLE3_SMCMD_MAXCMD         0x000f

struct qfle3_q_params {
   vmk_uint32 param;
   struct qfle3_fastpath *fp;
};



#define QFLE3_SM_SUPPORT(state)     (1 << state)

/* statemachine command status */
typedef enum {
   QFLE3_SMCMD_STATUS_COMPLETED = 0x0000,
   QFLE3_SMCMD_STATUS_INPROGRESS = 0x0001,
   QFLE3_SMCMD_STATUS_ERROR = 0x0002,
   QFLE3_SMCMD_STATUS_NOTREADY = 0x0003,
   QFLE3_SMCMD_STATUS_WRONGSTATE = 0x0004,
} QFLE3_SMCMD_STATUS;


/* This function should be called once after driver load.  It will query and hw and initialize the statemachine */
/* After calling this function, the adapter should never be in QFLE3_SM_NOTREADY state unless the hw/fw is not behaving*/

//VMK_ReturnStatus qfle3_init_statemachine(struct qfle3_adapter *adapter);

//void qfle3_deinit_statemachine(struct qfle3_adapter *adapter);

/* Call this function to get the state of the SM.  Returns:
 * QFLE3_SM_STANDBY
 * QFLE3_SM_HWREADY
 * QFLE3_SM_DEVREADY
 * QFLE3_SM_PORTREADY
 * QFLE3_SM_FUNCREADY
 *
 * If the adapter is in the progress of completing a command, then return
 * QFLE3_SM_NOTREADY
 */
vmk_uint16 qfle3_sm_getstate(struct qfle3_adapter *adapter);


/* call this function to issue a command to the statemachine.
 * a command can be one of the statemachine commands above.
 * return statemachine command status
 
 * QFLE3_SMCMD_STATUS_COMPLETED
 * QFLE3_SMCMD_STATUS_INPROGRESS
 * QFLE3_SMCMD_STATUS_ERROR
 * QFLE3_SMCMD_STATUS_NOTREADY
 */
QFLE3_SMCMD_STATUS qfle3_sm_cmd(struct qfle3_adapter *adapter, vmk_uint16 cmd, vmk_uint32 param);
QFLE3_SMCMD_STATUS qfle3_sm_q_cmd(struct qfle3_adapter *adapter, vmk_uint16 cmd, int idx, vmk_uint32 param);


void qfle3_sm_change_state(struct qfle3_adapter *adapter, vmk_uint16 new_state);
VMK_ReturnStatus
qfle3_register_fp_interrupts(qfle3_adapter * adapter);

VMK_ReturnStatus
qfle3_unmask_fp_interrupts(qfle3_adapter * adapter);
void
qfle3_netpoll_disable(qfle3_adapter * adapter);
void
qfle3_unset_netpoll_interrupts(qfle3_adapter * adapter);

void
qfle3_netpoll_disable(qfle3_adapter * adapter);
void
qfle3_unregister_fp_interrupts(qfle3_adapter * adapter);

void
qfle3_link_down(qfle3_adapter * adapter);
void
qfle3_link_up(qfle3_adapter * adapter);
void
qfle3_mask_fp_interrupts(qfle3_adapter * adapter);
const char* qfle3_sm_get_string(vmk_uint16 sm_state);

VMK_ReturnStatus qfle3_load(struct qfle3_adapter *adapter);
VMK_ReturnStatus qfle3_unload(struct qfle3_adapter *adapter);

extern VMK_ReturnStatus qfle3_activate_dev(qfle3_adapter * adapter);
extern void qfle3_deactive_dev(qfle3_adapter * adapter);
void qfle3_rq_release(qfle3_adapter *adapter, vmk_uint32 idx);
void qfle3_assert_tx_ring(struct qfle3_fastpath *fp);


#endif

